/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.objects.ArchivedLogFileResource;
import org.eclipse.orion.server.logs.objects.RollingFileAppenderResource;

public class LogUtils {
    private static final int BUFFER_SIZE = Integer.parseInt(PreferenceHelper.getString((String)"orion.logs.logBufferSize", (String)String.valueOf(65536)));

    public static String getContentType(File logFile) {
        String name = logFile.getName();
        String extension = null;
        int k = name.lastIndexOf(46);
        if (k > 0 && k < name.length() - 1) {
            extension = name.substring(k + 1).toLowerCase();
        }
        if (extension == null) {
            return "text/plain";
        }
        if ("gz".equals(extension)) {
            return "application/x-gzip";
        }
        if ("zip".equals(extension)) {
            return "application/zip";
        }
        return "text/plain";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void provideLogFile(File logFile, HttpServletResponse response) throws Exception {
        FilterInputStream in = null;
        ServletOutputStream output = null;
        try {
            block8: {
                int length;
                byte[] byteBuffer;
                block7: {
                    byteBuffer = new byte[BUFFER_SIZE];
                    in = new DataInputStream(new FileInputStream(logFile));
                    output = response.getOutputStream();
                    response.setContentType(LogUtils.getContentType(logFile));
                    response.setContentLength((int)logFile.length());
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + logFile.getName() + "\"");
                    length = 0;
                    if (!true) break block7;
                    if (in == null) return;
                    if ((length = ((DataInputStream)in).read(byteBuffer)) == -1) break block8;
                }
                do {
                    output.write(byteBuffer, 0, length);
                    if (in == null) return;
                } while ((length = ((DataInputStream)in).read(byteBuffer)) != -1);
            }
            return;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static void attachArchivedLogFiles(RollingFileAppender<ILoggingEvent> appender, RollingFileAppenderResource rollingFileAppenderResource, ILogService logService) {
        File[] files = logService.getArchivedLogFiles(appender);
        if (files == null) {
            return;
        }
        ArrayList<ArchivedLogFileResource> logFiles = new ArrayList<ArchivedLogFileResource>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ArchivedLogFileResource resource = new ArchivedLogFileResource(rollingFileAppenderResource, file);
            logFiles.add(resource);
            ++n2;
        }
        rollingFileAppenderResource.setArchivedLogFiles(logFiles);
    }
}

