/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.servlets;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.jobs.ListLoggersJob;
import org.eclipse.orion.server.logs.jobs.LoggerJob;
import org.eclipse.orion.server.logs.objects.LoggerResource;
import org.eclipse.orion.server.logs.servlets.AbstractLogHandler;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class LoggerHandler
extends AbstractLogHandler {
    public LoggerHandler(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService) throws ServletException {
        try {
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)new ListLoggersJob(TaskJobHandler.getUserId((HttpServletRequest)request), logService, LoggerHandler.getURI((HttpServletRequest)request)), (ServletResourceHandler)this.statusHandler);
        }
        catch (Exception e) {
            ServerStatus error = new ServerStatus(4, 500, "An error occured when looking for loggers.", (Throwable)e);
            LogHelper.log((IStatus)error);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
    }

    @Override
    protected boolean handleGet(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        String loggerName = path.segment(0);
        try {
            return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)new LoggerJob(TaskJobHandler.getUserId((HttpServletRequest)request), logService, LoggerHandler.getURI((HttpServletRequest)request), loggerName), (ServletResourceHandler)this.statusHandler);
        }
        catch (Exception e) {
            ServerStatus error = new ServerStatus(4, 500, "An error occured when looking for logger.", (Throwable)e);
            LogHelper.log((IStatus)error);
            return this.statusHandler.handleRequest(request, response, (Object)error);
        }
    }

    @Override
    protected boolean handlePut(HttpServletRequest request, HttpServletResponse response, ILogService logService, IPath path) throws ServletException {
        URI baseLocation = LoggerHandler.getURI((HttpServletRequest)request);
        try {
            String loggerName = path.segment(0);
            JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
            Logger logger = logService.getLogger(loggerName);
            if (logger == null) {
                String msg = NLS.bind((String)"Logger not found: {0}", (Object)loggerName);
                ServerStatus error = new ServerStatus(4, 404, msg, null);
                return this.statusHandler.handleRequest(request, response, (Object)error);
            }
            String putlevel = toPut.getString("Level");
            Level level = Level.toLevel((String)putlevel, (Level)logger.getLevel());
            logger.setLevel(level);
            LoggerResource loggerResource = new LoggerResource();
            loggerResource.setBaseLocation(baseLocation);
            loggerResource.setName(logger.getName());
            loggerResource.setLevel(logger.getLevel());
            loggerResource.setEffectiveLevel(logger.getEffectiveLevel());
            JSONObject result = loggerResource.toJSON();
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", result.getString("Location"));
            return true;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
        }
    }
}

