/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.file;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.DirectoryHandlerV1;
import org.eclipse.orion.internal.server.servlets.file.FileHandlerV1;
import org.eclipse.orion.internal.server.servlets.file.GenericDirectoryHandler;
import org.eclipse.orion.internal.server.servlets.file.GenericFileHandler;
import org.eclipse.orion.server.core.EncodingUtils;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletFileStoreHandler
extends ServletResourceHandler<IFileStore> {
    public static VersionRange VERSION1 = new VersionRange("[1,2)");
    private static int[] ATTRIBUTE_BITS = new int[]{8, 4, 16, 0x200000, 2, 32};
    private static String[] ATTRIBUTE_KEYS = new String[]{"Archive", "Executable", "Hidden", "Immutable", "ReadOnly", "SymLink"};
    private final ServletResourceHandler<IFileStore> directorySerializerV1;
    private final ServletResourceHandler<IFileStore> fileSerializerV1;
    private final ServletResourceHandler<IFileStore> genericDirectorySerializer;
    private final ServletResourceHandler<IFileStore> genericFileSerializer;
    final ServletResourceHandler<IStatus> statusHandler;

    public static IFileInfo fromJSON(JSONObject object) {
        FileInfo info = (FileInfo)EFS.createFileInfo();
        ServletFileStoreHandler.copyJSONToFileInfo(object, info);
        return info;
    }

    public static void copyJSONToFileInfo(JSONObject source, FileInfo destination) {
        destination.setName(source.optString("Name", destination.getName()));
        destination.setLastModified(source.optLong("LastModified", destination.getLastModified()));
        destination.setDirectory(source.optBoolean("Directory", destination.isDirectory()));
        JSONObject attributes = source.optJSONObject("Attributes");
        if (attributes != null) {
            int i = 0;
            while (i < ATTRIBUTE_KEYS.length) {
                if (!attributes.isNull(ATTRIBUTE_KEYS[i])) {
                    destination.setAttribute(ATTRIBUTE_BITS[i], attributes.optBoolean(ATTRIBUTE_KEYS[i]));
                }
                ++i;
            }
        }
    }

    public static IFileInfo fromJSON(HttpServletRequest request) throws IOException, JSONException {
        return ServletFileStoreHandler.fromJSON(OrionServlet.readJSONRequest(request));
    }

    public static JSONObject toJSON(IFileStore store, IFileInfo info, URI location) {
        JSONObject result = new JSONObject();
        try {
            JSONObject attributes;
            result.put("Name", (Object)info.getName());
            result.put("LocalTimeStamp", info.getLastModified());
            if (location != null || info.isDirectory()) {
                result.put("Directory", info.isDirectory());
            }
            result.put("Length", info.getLength());
            if (location != null) {
                if (info.isDirectory() && !location.getPath().endsWith("/")) {
                    location = URIUtil.append((URI)location, (String)"");
                }
                result.put("Location", (Object)location);
                try {
                    URI workspaceLocation = new URI(location.getScheme(), location.getAuthority(), "/workspace", null, location.getFragment());
                    workspaceLocation = URIUtil.append((URI)workspaceLocation, (String)new Path(location.getPath()).segment(1));
                    result.put("WorkspaceLocation", (Object)workspaceLocation);
                    if (info.isDirectory()) {
                        result.put("ChildrenLocation", (Object)new URI(location.getScheme(), location.getAuthority(), location.getPath(), "depth=1", location.getFragment()));
                    }
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((attributes = ServletFileStoreHandler.getAttributes(store, info, location == null)).keys().hasNext()) {
                result.put("Attributes", (Object)attributes);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static JSONObject getAttributes(IFileStore store, IFileInfo info, boolean optional) throws JSONException {
        int supported = store.getFileSystem().attributes();
        JSONObject attributes = new JSONObject();
        int i = 0;
        while (i < ATTRIBUTE_KEYS.length) {
            if ((supported & ATTRIBUTE_BITS[i]) != 0 && (!optional || info.getAttribute(ATTRIBUTE_BITS[i]))) {
                attributes.put(ATTRIBUTE_KEYS[i], info.getAttribute(ATTRIBUTE_BITS[i]));
            }
            ++i;
        }
        return attributes;
    }

    public ServletFileStoreHandler(ServletResourceHandler<IStatus> statusHandler, ServletContext context) {
        this.statusHandler = statusHandler;
        this.fileSerializerV1 = new FileHandlerV1(statusHandler, context);
        this.genericFileSerializer = new GenericFileHandler(context);
        this.directorySerializerV1 = new DirectoryHandlerV1(statusHandler);
        this.genericDirectorySerializer = new GenericDirectoryHandler();
    }

    private boolean handleDirectory(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        String versionString = request.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        ServletResourceHandler<IFileStore> handler = version != null && VERSION1.isIncluded(version) ? this.directorySerializerV1 : this.genericDirectorySerializer;
        return handler.handleRequest(request, response, file);
    }

    private boolean handleFile(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        String versionString = request.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        ServletResourceHandler<IFileStore> handler = version != null && VERSION1.isIncluded(version) ? this.fileSerializerV1 : this.genericFileSerializer;
        return handler.handleRequest(request, response, file);
    }

    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, IFileStore file) throws ServletException {
        IFileInfo fileInfo;
        try {
            fileInfo = file.fetchInfo(0, null);
        }
        catch (CoreException e) {
            if (this.handleAuthFailure(request, response, (Exception)((Object)e))) {
                return true;
            }
            fileInfo = new FileInfo(file.getName());
            ((FileInfo)fileInfo).setExists(false);
        }
        if (!request.getMethod().equals("PUT") && !fileInfo.exists()) {
            if ("true".equals(request.getHeader("read-if-exists"))) {
                return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(2, 204, NLS.bind((String)"No file content: {0}", (Object)EncodingUtils.encodeForHTML((String)request.getPathInfo())), null));
            }
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"File not found: {0}", (Object)EncodingUtils.encodeForHTML((String)request.getPathInfo())), null));
        }
        if ("true".equals(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"project"))) {
            return this.getProject(request, response, file, fileInfo);
        }
        if (fileInfo.isDirectory()) {
            return this.handleDirectory(request, response, file);
        }
        return this.handleFile(request, response, file);
    }

    private boolean getProject(HttpServletRequest request, HttpServletResponse response, IFileStore file, IFileInfo fileInfo) throws ServletException {
        String n = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"names");
        HashMap<String, Boolean> names = new HashMap<String, Boolean>();
        names.put(".git", true);
        names.put("project.json", false);
        if (n != null) {
            try {
                String[] clientNames;
                String[] stringArray = clientNames = URLDecoder.decode(n, "UTF-8").split(",");
                int n2 = clientNames.length;
                int n3 = 0;
                while (n3 < n2) {
                    String _n = stringArray[n3];
                    names.put(_n, false);
                    ++n3;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger logger = LoggerFactory.getLogger(ServletFileStoreHandler.class);
                logger.error("Failed to decode client project names: " + n);
            }
        }
        String pathString = request.getPathInfo();
        Path path = new Path(pathString);
        String workspacePath = null;
        String workspaceId = null;
        try {
            WorkspaceInfo workspace = OrionConfiguration.getMetaStore().readWorkspace(path.segment(0));
            workspaceId = workspace.getUniqueId();
            IFileStore userHome = OrionConfiguration.getMetaStore().getUserHome(workspace.getUserId());
            IFileStore workspaceHome = userHome.getChild(workspaceId.substring(workspaceId.indexOf(45) + 1));
            File workspaceRoot = workspaceHome.toLocalFile(0, null);
            workspacePath = workspaceRoot.getAbsolutePath();
        }
        catch (CoreException coreException) {
            Logger logger = LoggerFactory.getLogger(ServletFileStoreHandler.class);
            logger.error("Exception computing workspace path");
        }
        if (workspacePath == null) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(2, 204, NLS.bind((String)"No workspace path for: {0}", (Object)EncodingUtils.encodeForHTML((String)fileInfo.getName())), null));
        }
        if (workspaceId == null) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(2, 204, NLS.bind((String)"No workspace ID for: {0}", (Object)EncodingUtils.encodeForHTML((String)fileInfo.getName())), null));
        }
        IFileStore project = this.findProject(request, file, fileInfo, names, workspacePath);
        if (project == null) {
            return this.statusHandler.handleRequest(request, response, (IStatus)new ServerStatus(2, 204, NLS.bind((String)"No project context for: {0}", (Object)EncodingUtils.encodeForHTML((String)fileInfo.getName())), null));
        }
        try {
            URI location = this.getProjectURI(project.toURI(), workspacePath, workspaceId);
            JSONObject result = ServletFileStoreHandler.toJSON(project, project.fetchInfo(), location);
            OrionServlet.writeJSONResponse(request, response, result);
        }
        catch (IOException iOException) {
            Logger logger = LoggerFactory.getLogger(ServletFileStoreHandler.class);
            logger.error("Failed to write response for project: " + project.getName());
        }
        return true;
    }

    private URI getProjectURI(URI projectUri, String workspacePath, String workspaceId) {
        String pathInfo = projectUri.getPath().substring(workspacePath.length());
        try {
            return new URI("orion", null, "/file/" + workspaceId + pathInfo, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFileStore findProject(HttpServletRequest request, IFileStore file, IFileInfo fileInfo, HashMap<String, Boolean> names, String workspacePath) {
        IFileStore parent = file;
        try {
            File parentFile = parent.toLocalFile(0, null);
            if (parentFile == null) {
                Logger logger = LoggerFactory.getLogger(ServletFileStoreHandler.class);
                logger.error("Unable to get the parent local file from: " + parent);
                return null;
            }
            block2: while (true) {
                IFileInfo[] children;
                if (parent == null) return null;
                if (parentFile == null) return null;
                if (!parentFile.getAbsolutePath().startsWith(workspacePath)) {
                    return null;
                }
                IFileInfo[] iFileInfoArray = children = parent.childInfos(0, null);
                int n = children.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        parent = parent.getParent();
                        parentFile = parent.toLocalFile(0, null);
                        continue block2;
                    }
                    IFileInfo childInfo = iFileInfoArray[n2];
                    if (childInfo.exists() && names.containsKey(childInfo.getName())) {
                        if (childInfo.isDirectory() && names.get(childInfo.getName()).booleanValue()) {
                            return parent;
                        }
                        if (!names.get(childInfo.getName()).booleanValue()) {
                            return parent;
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (CoreException coreException) {
            Logger logger = LoggerFactory.getLogger(ServletFileStoreHandler.class);
            logger.error("Exception computing parent folder from: " + parent);
            return null;
        }
    }
}

