/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.ParseManifestCommand;
import org.eclipse.orion.server.cf.ds.IDeploymentService;
import org.eclipse.orion.server.cf.ds.objects.Plan;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ApplicationReconstructor;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlansHandlerV1
extends AbstractRESTHandler<Plan> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public PlansHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Plan buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Plan pathPlan, HttpServletRequest request, HttpServletResponse response, final String path) {
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    Path contentPath = new Path(path.startsWith("/") ? path : "/" + path);
                    if (!AuthorizationService.checkRights((String)this.userId, (String)contentPath.toString(), (String)"GET")) {
                        return new ServerStatus(4, 403, "Forbidden access to application contents", null);
                    }
                    IFileStore contentLocation = NewFileServlet.getFileStore(null, (IPath)contentPath.removeFirstSegments(1));
                    if (!contentLocation.fetchInfo().isDirectory()) {
                        contentLocation = contentLocation.getParent();
                    }
                    ManifestParseTree manifest = null;
                    ParseManifestCommand parseManifestCommand = new ParseManifestCommand(null, this.userId, contentPath.toString());
                    parseManifestCommand.setApplicationAnalyzer(new ApplicationReconstructor());
                    IStatus status = parseManifestCommand.doIt();
                    IFileStore manifestStore = parseManifestCommand.getManifestStore();
                    if (status.isOK()) {
                        manifest = parseManifestCommand.getManifest();
                    }
                    IDeploymentService deploymentService = CFActivator.getDefault().getDeploymentService();
                    List<Plan> plans = deploymentService.getDeploymentPlans(contentLocation, manifest, manifestStore);
                    JSONArray children = new JSONArray();
                    for (Plan plan : plans) {
                        children.put((Object)plan.toJSON());
                    }
                    JSONObject resp = new JSONObject();
                    resp.put("Children", (Object)children);
                    return new ServerStatus(Status.OK_STATUS, 200, resp);
                }
                catch (Exception ex) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)ex);
                    PlansHandlerV1.this.logger.error(msg, (Throwable)ex);
                    return status;
                }
            }
        };
    }
}

