/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.workspace.MetadataInfoResourceHandler;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.MetadataInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoResourceHandler
extends MetadataInfoResourceHandler<UserInfo> {
    @Override
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, UserInfo user) throws ServletException {
        return false;
    }

    public static JSONObject toJSON(UserInfo user, URI baseLocation) {
        JSONObject result = MetadataInfoResourceHandler.toJSON((MetadataInfo)user);
        try {
            result.put("UserName", (Object)user.getUserName());
            JSONArray workspacesJSON = new JSONArray();
            for (String workspaceId : user.getWorkspaceIds()) {
                WorkspaceInfo workspaceInfo = OrionConfiguration.getMetaStore().readWorkspace(workspaceId);
                JSONObject workspace = new JSONObject();
                workspace.put("Name", (Object)workspaceInfo.getFullName());
                workspace.put("Id", (Object)workspaceId);
                workspace.put("Location", (Object)URIUtil.append((URI)baseLocation, (String)workspaceId));
                workspacesJSON.put((Object)workspace);
            }
            result.put("Workspaces", (Object)workspacesJSON);
        }
        catch (CoreException coreException) {
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

