/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.useradmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.useradmin.ServletUserHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class UserServlet
extends OrionServlet {
    private static final long serialVersionUID = -6809742538472682623L;
    private List<String> authorizedAccountCreators;
    private ServletResourceHandler<String> userSerializer;

    private boolean canAccess(String login, HttpServletRequest req) {
        try {
            String requestPath = String.valueOf(req.getServletPath()) + (req.getPathInfo() == null ? "" : req.getPathInfo());
            return AuthorizationService.checkRights(login, requestPath, req.getMethod());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void init() throws ServletException {
        this.userSerializer = new ServletUserHandler(this.getStatusHandler());
        String creators = PreferenceHelper.getString((String)"orion.auth.user.creation", null);
        if (creators != null) {
            this.authorizedAccountCreators = new ArrayList<String>();
            this.authorizedAccountCreators.addAll(Arrays.asList(creators.split(",")));
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String login = req.getRemoteUser();
        JSONObject json = null;
        try {
            json = OrionServlet.readJSONRequest(req);
        }
        catch (JSONException jSONException) {}
        if ("POST".equals(req.getMethod())) {
            if (json != null && !json.has("Reset")) {
                if (this.authorizedAccountCreators != null && !this.authorizedAccountCreators.contains(login)) {
                    this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Forbidden access"), 403);
                    return;
                }
            } else if (login == null || !this.canAccess(login, req)) {
                this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Forbidden access"), 403);
                return;
            }
        } else {
            if (login == null) {
                this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Forbidden access"), 403);
                return;
            }
            if (!this.canAccess(login, req)) {
                this.handleException(resp, (IStatus)new Status(4, "org.eclipse.orion.server.servlets", "Forbidden access"), 403);
                return;
            }
        }
        this.traceRequest(req);
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && !pathInfo.equals("/")) {
            String userId = pathInfo.split("\\/")[1];
            UserInfo userInfo = null;
            try {
                userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", userId, false, false);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
                resp.sendError(500, e.getMessage());
                return;
            }
            if (userInfo == null) {
                this.handleException(resp, (IStatus)new ServerStatus(4, 404, NLS.bind((String)"User not found: {0}", (Object)userId), null));
                return;
            }
        }
        if (this.userSerializer.handleRequest(req, resp, pathInfo)) {
            return;
        }
        super.service(req, resp);
    }
}

