/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteApplicationCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Delete the application";
    private App application;
    private String appName;

    public DeleteApplicationCommand(Target target, App app) {
        super(target);
        this.application = app;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            JSONObject appMetadata = null;
            JSONObject appEntity = null;
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String appsUrl = this.target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
            URI appsURI = targetURI.resolve(appsUrl);
            GetMethod getAppsMethod = new GetMethod(appsURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            getAppsMethod.setQueryString("q=name:" + this.appName + "&inline-relations-depth=1");
            ServerStatus appsStatus = HttpUtil.executeMethod((HttpMethodBase)getAppsMethod);
            if (!appsStatus.isOK()) {
                return appsStatus;
            }
            JSONObject apps = appsStatus.getJsonData();
            if (!apps.has("resources") || apps.getJSONArray("resources").length() == 0) {
                return new ServerStatus(4, 404, "Application not found", null);
            }
            appMetadata = apps.getJSONArray("resources").getJSONObject(0).getJSONObject("metadata");
            appEntity = apps.getJSONArray("resources").getJSONObject(0).getJSONObject("entity");
            if (this.application.getGuid() == null) {
                String summaryAppUrl = String.valueOf(appMetadata.getString("url")) + "/summary";
                URI summaryAppURI = targetURI.resolve(summaryAppUrl);
                GetMethod getSummaryMethod = new GetMethod(summaryAppURI.toString());
                confStatus = HttpUtil.configureHttpMethod((HttpMethod)getSummaryMethod, this.target.getCloud());
                if (!confStatus.isOK()) {
                    return confStatus;
                }
                ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getSummaryMethod);
                if (!getStatus.isOK()) {
                    return getStatus;
                }
                JSONObject summaryJSON = getStatus.getJsonData();
                this.application.setGuid(summaryJSON.getString("guid"));
            }
            ArrayList<String> serviceInstances = new ArrayList<String>();
            JSONArray appServiceBindings = appEntity.getJSONArray("service_bindings");
            int i = 0;
            while (i < appServiceBindings.length()) {
                JSONObject binding = appServiceBindings.getJSONObject(i).getJSONObject("entity");
                serviceInstances.add(binding.getString("service_instance_url"));
                ++i;
            }
            URI appURI = targetURI.resolve("/v2/apps/" + this.application.getGuid());
            DeleteMethod deleteAppMethod = new DeleteMethod(appURI.toString());
            confStatus = HttpUtil.configureHttpMethod((HttpMethod)deleteAppMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            deleteAppMethod.setQueryString("recursive=true");
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)deleteAppMethod);
            GetAppCommand.expire(this.target, this.application.getName());
            return status;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    @Override
    protected IStatus validateParams() {
        try {
            ManifestParseTree manifest = this.application.getManifest();
            ManifestParseTree app = manifest.get("applications").get(0);
            if (this.application.getName() != null) {
                this.appName = this.application.getName();
                return Status.OK_STATUS;
            }
            this.appName = app.get("name").getValue();
            return Status.OK_STATUS;
        }
        catch (InvalidAccessException e) {
            return new ServerStatus(4, 400, e.getMessage(), null);
        }
    }
}

