/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.utils;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.utils.MagicJSONObject;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    private static final int DEFAULT_SOCKET_TIMEOUT = 300000;

    public static ServerStatus configureHttpMethod(HttpMethod method, Cloud cloud) throws JSONException {
        method.addRequestHeader(new Header("Accept", "application/json"));
        method.addRequestHeader(new Header("Content-Type", "application/json"));
        HttpMethodParams params = method.getParams();
        params.setSoTimeout(300000);
        params.setContentCharset("UTF-8");
        method.setParams(params);
        if (cloud.getAccessToken() != null) {
            method.addRequestHeader(new Header("Authorization", "bearer " + cloud.getAccessToken().getString("access_token")));
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        JSONObject errorJSON = new JSONObject();
        try {
            errorJSON.put("regionId", (Object)cloud.getRegion());
            errorJSON.put("regionName", (Object)(cloud.getRegionName() != null ? cloud.getRegionName() : ""));
            errorJSON.put("error_code", (Object)"CF-NotAuthenticated");
            errorJSON.put("description", (Object)"Not authenticated");
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(4, 401, "Not authenticated", errorJSON, null);
    }

    public static ServerStatus executeMethod(HttpMethodBase method) throws HttpException, IOException, JSONException {
        try {
            MagicJSONObject result;
            int code = CFActivator.getDefault().getHttpClient().executeMethod((HttpMethod)method);
            if (code == 204) {
                ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200);
                return serverStatus;
            }
            String response = method.getResponseBodyAsString(0x4000000);
            try {
                result = new MagicJSONObject(response);
            }
            catch (JSONException jSONException) {
                result = new JSONObject();
                result.put("response", response);
            }
            if (code != 200 && code != 201) {
                String desctiption = result.optString("description");
                if ((desctiption == null || desctiption.length() == 0) && (desctiption = result.optString("response", "Could not connect to host. Error: " + code)).length() > 1000) {
                    desctiption = "Could not connect to host. Error: " + code;
                }
                ServerStatus serverStatus = new ServerStatus(4, code, desctiption, (JSONObject)result, null);
                return serverStatus;
            }
            if (result.has("error_code")) {
                ServerStatus serverStatus = new ServerStatus(4, 500, result.optString("description"), (JSONObject)result, null);
                return serverStatus;
            }
            ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, (JSONObject)result);
            return serverStatus;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static ServerStatus createErrorStatus(int severity, String errorCode, String description) {
        JSONObject errorJSON = new JSONObject();
        try {
            errorJSON.put("error_code", (Object)errorCode);
            errorJSON.put("description", (Object)description);
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(severity, 500, description, errorJSON, null);
    }

    public static ServerStatus createErrorStatus(int severity, String errorCode, String description, JSONObject metadata) {
        JSONObject errorJSON = new JSONObject();
        try {
            errorJSON.put("error_code", (Object)errorCode);
            errorJSON.put("description", (Object)description);
            errorJSON.put("metadata", (Object)metadata);
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(severity, 500, description, errorJSON, null);
    }
}

