/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.tasks.TaskInfo;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.git.IGitHubTokenProvider;
import org.eclipse.orion.server.git.jobs.EclipseGitProgressTransformer;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.jobs.GitJobUtils;
import org.eclipse.orion.server.git.objects.Clone;
import org.eclipse.orion.server.git.servlets.GitCloneHandlerV1;
import org.json.JSONException;
import org.json.JSONObject;

public class CloneJob
extends GitJob {
    private final ProjectInfo project;
    private final Clone clone;
    private final String user;
    private final String gitUserName;
    private final String gitUserMail;
    private String cloneLocation;
    private final boolean initProject;
    private final boolean cloneSubmodules;

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail, boolean initProject, boolean cloneSubmodules) {
        super(userRunningTask, true, (GitCredentialsProvider)credentials);
        this.clone = clone;
        this.user = user;
        this.project = project;
        this.gitUserName = gitUserName;
        this.gitUserMail = gitUserMail;
        this.cloneLocation = cloneLocation;
        this.initProject = initProject;
        this.cloneSubmodules = cloneSubmodules;
        this.setFinalMessage("Clone complete.");
        this.setTaskExpirationTime(TimeUnit.DAYS.toMillis(7L));
    }

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail) {
        this(clone, userRunningTask, credentials, user, cloneLocation, project, gitUserName, gitUserMail, false, true);
    }

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail, boolean initProject, Object cookie) {
        this(clone, userRunningTask, credentials, user, cloneLocation, project, gitUserName, gitUserMail, initProject, true, cookie);
    }

    public CloneJob(Clone clone, String userRunningTask, CredentialsProvider credentials, String user, String cloneLocation, ProjectInfo project, String gitUserName, String gitUserMail, boolean initProject, boolean cloneSubmodules, Object cookie) {
        this(clone, userRunningTask, credentials, user, cloneLocation, project, gitUserName, gitUserMail, initProject, cloneSubmodules);
        this.cookie = (Cookie)cookie;
    }

    public synchronized TaskInfo startTask() {
        TaskInfo task = super.startTask();
        task.setLengthComputable(true);
        return task;
    }

    /*
     * Loose catch block
     */
    private IStatus doClone(IProgressMonitor monitor) {
        block35: {
            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(monitor, this);
            Repository repo = null;
            try {
                IStatus iStatus;
                File gitModule;
                File cloneFolder = new File(this.clone.getContentLocation().getPath());
                if (!cloneFolder.exists()) {
                    cloneFolder.mkdir();
                }
                CloneCommand cc = Git.cloneRepository();
                cc.setProgressMonitor((ProgressMonitor)gitMonitor);
                cc.setBare(false);
                cc.setCredentialsProvider((CredentialsProvider)this.credentials);
                cc.setDirectory(cloneFolder);
                cc.setRemote("origin");
                cc.setURI(this.clone.getUrl());
                cc.setCloneSubmodules(this.cloneSubmodules);
                if (this.cookie != null) {
                    cc.setTransportConfigCallback(new TransportConfigCallback(){

                        public void configure(Transport t) {
                            if (t instanceof TransportHttp && CloneJob.this.cookie != null) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("Cookie", String.valueOf(CloneJob.this.cookie.getName()) + "=" + CloneJob.this.cookie.getValue());
                                ((TransportHttp)t).setAdditionalHeaders(map);
                            }
                        }
                    });
                }
                Git git = cc.call();
                if (monitor.isCanceled()) {
                    Status status = new Status(8, "org.eclipse.orion.server.git", "Cancelled");
                    return status;
                }
                GitCloneHandlerV1.doConfigureClone(git, this.user, this.gitUserName, this.gitUserMail);
                repo = git.getRepository();
                if (!this.cloneSubmodules && (gitModule = new File(repo.getWorkTree(), ".gitmodules")).exists() && !gitModule.isDirectory()) {
                    SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repo);
                    while (walk.next()) {
                        Repository subRepo = walk.getRepository();
                        if (subRepo != null || walk.getDirectory().exists()) continue;
                        walk.getDirectory().mkdir();
                    }
                    walk.close();
                }
                GitJobUtils.packRefs(repo, gitMonitor);
                if (monitor.isCanceled()) {
                    Status status = new Status(8, "org.eclipse.orion.server.git", "Cancelled");
                    return status;
                }
                try {
                    File projectJsonFile;
                    if (!this.initProject || (projectJsonFile = new File(String.valueOf(cloneFolder.getPath()) + File.separator + "project.json")).exists()) break block35;
                    PrintStream out = null;
                    try {
                        String repoName;
                        String[] segments;
                        String serverName;
                        out = new PrintStream(new FileOutputStream(projectJsonFile));
                        JSONObject projectjson = new JSONObject();
                        String gitPath = this.clone.getUrl();
                        if (gitPath.indexOf("://") > 0) {
                            gitPath = gitPath.substring(gitPath.indexOf("://") + 3);
                        }
                        if ((serverName = (segments = gitPath.split("/"))[0]).indexOf("@") > 0) {
                            serverName = serverName.substring(serverName.indexOf("@") + 1);
                        }
                        if ((repoName = segments[segments.length - 1]).indexOf(".git") > 0) {
                            repoName = repoName.substring(0, repoName.lastIndexOf(".git"));
                        }
                        projectjson.put("Name", (Object)(String.valueOf(repoName) + " at " + serverName));
                        out.print(projectjson.toString());
                        break block35;
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e);
                    return status;
                }
                catch (CoreException e) {
                    IStatus iStatus2 = e.getStatus();
                    return iStatus2;
                }
                catch (GitAPIException e) {
                    IStatus result = this.getGitAPIExceptionStatus(e, "Error cloning git repository");
                    if (CloneJob.matchMessage(JGitText.get().notAuthorized, e.getCause().getMessage())) {
                        try {
                            String repositoryUrl = this.clone.getUrl();
                            Enumeration<IGitHubTokenProvider> providers = GitCredentialsProvider.GetGitHubTokenProviders();
                            while (providers.hasMoreElements()) {
                                String authUrl = providers.nextElement().getAuthUrl(repositoryUrl, this.cookie);
                                if (authUrl == null) continue;
                                ServerStatus status = ServerStatus.convert((IStatus)result);
                                JSONObject data = status.getJsonData();
                                data.put("GitHubAuth", (Object)authUrl);
                                break;
                            }
                        }
                        catch (JSONException jSONException) {}
                    }
                    iStatus = result;
                }
                return iStatus;
                catch (JGitInternalException e) {
                    IStatus iStatus3 = this.getJGitInternalExceptionStatus(e, "Error cloning git repository");
                    return iStatus3;
                }
                catch (Exception e2) {
                    Status status = new Status(4, "org.eclipse.orion.server.git", "Error cloning git repository", (Throwable)e2);
                    return status;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (repo != null) {
                    repo.close();
                }
            }
        }
        JSONObject jsonData = new JSONObject();
        try {
            jsonData.put("Location", (Object)URI.create(this.cloneLocation));
        }
        catch (JSONException jSONException) {}
        return new ServerStatus(Status.OK_STATUS, 200, jsonData);
    }

    protected IStatus performJob(IProgressMonitor monitor) {
        IStatus result = this.doClone(monitor);
        if (result.isOK()) {
            return result;
        }
        if (this.project != null) {
            GitCloneHandlerV1.removeProject(this.user, this.project);
        }
        return result;
    }
}

