/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.authentication.IAuthenticationService;
import org.eclipse.orion.server.core.EncodingUtils;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Version;

public class AuthorizedUserFilter
implements Filter {
    private IAuthenticationService authenticationService;

    public void init(FilterConfig filterConfig) throws ServletException {
        String msg;
        while (Activator.getDefault() == null) {
            msg = "Authentication service is not active. AuthorizedUserFilter is waiting.";
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.servlets", msg, null));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        while (Activator.getDefault().getAuthService() == null) {
            msg = "Authentication service is not active. AuthorizedUserFilter is waiting. The server configuration must specify an authentication scheme, or use \"None\" to indicate no authentication";
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.servlets", msg, null));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.authenticationService = Activator.getDefault().getAuthService();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String remoteUser = httpRequest.getRemoteUser();
        String userName = remoteUser;
        if (userName == null && (userName = this.authenticationService.getAuthenticatedUser(httpRequest, httpResponse)) == null) {
            userName = "anonymous";
        }
        try {
            String xCreateOptions;
            String requestPath = String.valueOf(httpRequest.getServletPath()) + (httpRequest.getPathInfo() == null ? "" : httpRequest.getPathInfo());
            if (!AuthorizationService.checkRights(userName, requestPath, httpRequest.getMethod())) {
                if ("anonymous".equals(userName)) {
                    userName = this.authenticationService.authenticateUser(httpRequest, httpResponse);
                    if (userName == null) {
                        return;
                    }
                } else {
                    this.setNotAuthorized(httpRequest, httpResponse, requestPath);
                    return;
                }
            }
            if ((xCreateOptions = httpRequest.getHeader("X-Create-Options")) != null) {
                String sourceLocation = null;
                try {
                    String method = xCreateOptions.contains("move") ? "POST" : "GET";
                    JSONObject requestObject = OrionServlet.readJSONRequest(httpRequest);
                    sourceLocation = requestObject.getString("Location");
                    String normalizedLocation = new URI(sourceLocation).normalize().getPath();
                    String string = normalizedLocation = normalizedLocation.startsWith(httpRequest.getContextPath()) ? normalizedLocation.substring(httpRequest.getContextPath().length()) : null;
                    if (normalizedLocation == null || !AuthorizationService.checkRights(userName, normalizedLocation, method)) {
                        this.setNotAuthorized(httpRequest, httpResponse, sourceLocation);
                        return;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.setNotAuthorized(httpRequest, httpResponse, sourceLocation);
                    return;
                }
                catch (JSONException jSONException) {}
            }
            if (remoteUser == null && !"anonymous".equals(userName)) {
                request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)userName);
                request.setAttribute("org.osgi.service.http.authentication.type", (Object)this.authenticationService.getAuthType());
            }
        }
        catch (CoreException coreException) {
            httpResponse.sendError(500);
            return;
        }
        chain.doFilter(request, response);
    }

    private void setNotAuthorized(HttpServletRequest req, HttpServletResponse resp, String resourceURL) throws IOException {
        String versionString = req.getHeader("Orion-Version");
        Version version = versionString == null ? null : new Version(versionString);
        String xRequestedWith = req.getHeader("X-Requested-With");
        String msg = "You are not authorized to access " + resourceURL;
        resp.setHeader("Cache-Control", "no-cache");
        if (version == null && !"XMLHttpRequest".equals(xRequestedWith)) {
            resp.sendError(403, msg);
        } else {
            resp.setContentType("application/json; charset=UTF-8");
            ServerStatus serverStatus = new ServerStatus(4, 403, EncodingUtils.encodeForHTML((String)msg), null);
            resp.setStatus(403);
            resp.getWriter().print(serverStatus.toJSON().toString());
        }
    }

    public void destroy() {
    }
}

