/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface.user;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.products.model.api.Product;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportCustomersWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.PageObserver;
import org.eclipse.passage.loc.report.internal.ui.jface.user.Products;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

final class ScopePage
extends WizardPage {
    private final Product[] products;
    private final Set<Product> selected;
    private final PageObserver preview;
    private Button all;
    private Button none;
    private CheckboxTableViewer viewer;

    protected ScopePage(Products products, PageObserver preview) {
        super("scope");
        this.preview = preview;
        this.products = products.get();
        this.selected = new HashSet<Product>();
        this.setTitle(ExportCustomersWizardMessages.ScopePage_title);
        this.setMessage(ExportCustomersWizardMessages.ScopePage_description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.createViewer(content);
        this.createButtons(content);
        this.setControl((Control)content);
    }

    void installInitial() {
        this.selected.addAll(Arrays.asList(this.products));
        this.viewer.refresh();
        this.updateControls();
    }

    Set<String> identifiers() {
        return this.selected.stream().map(Product::getIdentifier).collect(Collectors.toSet());
    }

    private CheckboxTableViewer createViewer(Composite content) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)content, (int)68352);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ScopePage.this.selected.contains(element);
            }
        });
        this.viewer.setInput((Object)this.products);
        return this.viewer;
    }

    private void createButtons(Composite content) {
        Composite controls = new Composite(content, 0);
        controls.setLayoutData((Object)new GridData(131072, 128, false, false));
        controls.setLayout((Layout)new FillLayout(512));
        this.all = new Button(controls, 8);
        this.all.setText(ExportWizardMessages.ScopePage_selectAll);
        this.none = new Button(controls, 8);
        this.none.setText(ExportWizardMessages.ScopePage_selctNone);
        this.all.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Arrays.stream(this.products).forEach(this.selected::add);
            this.viewer.refresh();
            this.updateControls();
        }));
        this.none.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selected.clear();
            this.viewer.refresh();
            this.updateControls();
        }));
        this.viewer.addCheckStateListener(e -> {
            if (e.getChecked()) {
                this.selected.add((Product)e.getElement());
            } else {
                this.selected.remove(e.getElement());
            }
            this.updateControls();
        });
    }

    private void updateControls() {
        this.updateLocalControls();
        this.preview.update();
    }

    private void updateLocalControls() {
        this.all.setEnabled(this.products.length > 0 && this.selected.size() < this.products.length);
        this.none.setEnabled(!this.selected.isEmpty());
    }

    private void createColumns() {
        TableViewerColumn product = new TableViewerColumn((TableViewer)this.viewer, 0);
        product.getColumn().setWidth(500);
        product.getColumn().setText(ExportCustomersWizardMessages.ScopePage_columnProduct);
        product.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Product)element).getName();
            }
        });
    }
}

