/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.request;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.runtime.ServerRequestAction;
import org.eclipse.passage.lbc.runtime.ServerRequestExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LoggerFactory;

@Component
public class ClientRequestExecutor
extends BaseComponent
implements ServerRequestExecutor {
    private static Map<String, ServerRequestAction> mapActionRequest = new HashMap<String, ServerRequestAction>();
    private static final String EXECUTION_ACTION_ERROR = "Execution action: [%s] result [FALSE]";
    private static final String RECIEVED_ACTION_TXT = "Recieved action id [%s]";
    private static final Object CLIENT_TRUSTED_VALUE = "12345678";
    private static final String RESPONSE_ERROR_UNTRUSTED = "Recieved unttrusted client";
    private static final String MSG_REQUEST_ACTION_NOT_FOUND_ERROR = "Action executor with id: [%s] not registered";
    private String accessModeId = "";

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    public void executeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String actionId = request.getParameter("action");
        this.logger.info(String.format(RECIEVED_ACTION_TXT, actionId));
        if (this.clientRecognition(request)) {
            ServerRequestAction requestAction = mapActionRequest.get(actionId);
            if (requestAction == null) {
                this.logger.info(String.format(MSG_REQUEST_ACTION_NOT_FOUND_ERROR, actionId));
                return;
            }
            if (!requestAction.execute(request, response)) {
                this.logger.info(EXECUTION_ACTION_ERROR, (Object)requestAction.getClass().getName());
                response.setStatus(400);
            }
        } else {
            this.logger.info(RESPONSE_ERROR_UNTRUSTED);
        }
    }

    public boolean clientRecognition(HttpServletRequest request) {
        String httpClientTrustId = request.getParameter("user");
        return CLIENT_TRUSTED_VALUE.equals(httpClientTrustId);
    }

    public boolean checkAccesstMode(HttpServletRequest baseRequest) {
        String requestAccessMode = baseRequest.getParameter("mode");
        return requestAccessMode != null && requestAccessMode.equals(this.accessModeId);
    }

    public void setRequestAction(Map<String, ServerRequestAction> mapActions) {
        mapActionRequest.putAll(mapActions);
    }

    public void setAccessModeId(String accessModeId) {
        this.accessModeId = accessModeId;
    }
}

