/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.internal.base.requirements.RequirementsFeatureFilter;

public final class Requirements
implements Supplier<ServiceInvocationResult<Collection<Requirement>>> {
    private final Registry<StringServiceId, ResolvedRequirements> registry;
    private final Function<ServiceInvocationResult<Collection<Requirement>>, ServiceInvocationResult<Collection<Requirement>>> filter;

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry, String feature) {
        this(registry, (Function<ServiceInvocationResult<Collection<Requirement>>, ServiceInvocationResult<Collection<Requirement>>>)new RequirementsFeatureFilter(feature).get());
    }

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry) {
        this(registry, Function.identity());
    }

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry, Function<ServiceInvocationResult<Collection<Requirement>>, ServiceInvocationResult<Collection<Requirement>>> filter) {
        Objects.requireNonNull(registry, "Requirements::registry");
        Objects.requireNonNull(filter, "Requirements::filter");
        this.registry = registry;
        this.filter = filter;
    }

    @Override
    public ServiceInvocationResult<Collection<Requirement>> get() {
        if (this.registry.services().isEmpty()) {
            return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new NoServicesOfType("requirement resolution"), BaseMessages.getString("Requirements.failed")));
        }
        return this.registry.services().stream().map(ResolvedRequirements::all).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).map(this.filter).get();
    }
}

