/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;

public final class FileCollection {
    private final Supplier<Path> base;
    private final PassageFileExtension extensions;

    public FileCollection(Supplier<Path> base, PassageFileExtension extension) {
        Objects.requireNonNull(base, "FileCollection::base path");
        Objects.requireNonNull(extension, "FileCollection::extension");
        this.base = base;
        this.extensions = extension;
    }

    public Collection<Path> get() throws LicensingException {
        HunterFiles hunter = new HunterFiles(this.extensions);
        try {
            Files.walkFileTree(this.base.get(), hunter);
        }
        catch (IOException e) {
            new LicensingException(BaseMessages.getString("FileCollection.failure"), (Throwable)e);
        }
        return hunter.findings();
    }

    private static final class HunterFiles
    extends SimpleFileVisitor<Path> {
        private final List<Path> findings = new ArrayList<Path>();
        private final PassageFileExtension extension;

        HunterFiles(PassageFileExtension extension) {
            this.extension = extension;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileName().toString().endsWith((String)this.extension.get())) {
                this.findings.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        Collection<Path> findings() {
            return this.findings;
        }
    }
}

