/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.base.i18n.DiagnosticExplainedMessages;

public final class DiagnosticExplained
implements Supplier<String> {
    private final Diagnostic diagnostic;

    public DiagnosticExplained(Diagnostic diagnostic) {
        Objects.requireNonNull(diagnostic, "DiagnosticExplained::diagnostic");
        this.diagnostic = diagnostic;
    }

    @Override
    public String get() {
        if (this.empty()) {
            return DiagnosticExplainedMessages.getString("DiagnosticExplained.empty");
        }
        StringBuilder out = new StringBuilder();
        out.append(DiagnosticExplainedMessages.getString("DiagnosticExplained.prelude")).append("\r\n");
        this.append(this.diagnostic.severe(), DiagnosticExplainedMessages.getString("DiagnosticExplained.severe"), out);
        this.append(this.diagnostic.bearable(), DiagnosticExplainedMessages.getString("DiagnosticExplained.bearable"), out);
        return out.toString();
    }

    private boolean empty() {
        return this.diagnostic.severe().isEmpty() && this.diagnostic.bearable().isEmpty();
    }

    private void append(List<Trouble> troubles, String name, StringBuilder out) {
        if (troubles.isEmpty()) {
            return;
        }
        out.append(name).append("\r\n");
        troubles.forEach(trouble -> this.append((Trouble)trouble, out));
    }

    private void append(Trouble trouble, StringBuilder out) {
        out.append("\r\n\t").append(trouble.details()).append(" (").append(trouble.code().code()).append(": ").append(trouble.code().explanation()).append(")").append(trouble.exception().isPresent() ? DiagnosticExplainedMessages.getString("DiagnosticExplained.failure") : "");
        if (trouble.exception().isPresent()) {
            StringWriter media = new StringWriter();
            ((Exception)trouble.exception().get()).printStackTrace(new PrintWriter(media));
            out.append("\r\n----\r\n").append(media.toString()).append("----\r\n");
        }
    }
}

