/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.requirements.Feature;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.Restriction;
import org.eclipse.passage.lic.internal.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.internal.jface.i18n.LicenseStatusDialogMessages;

final class RequirementStatus {
    private final String feature;
    private final String status;
    private final RestrictionLevel level;

    RequirementStatus(Restriction restriction) {
        this.feature = this.explain(restriction.unsatisfiedRequirement().feature());
        this.status = this.explain(restriction.reason());
        this.level = restriction.unsatisfiedRequirement().restrictionLevel();
    }

    RequirementStatus(Requirement requirement) {
        this.feature = this.explain(requirement.feature());
        this.status = LicenseStatusDialogMessages.RequirementStatus_status_ok;
        this.level = requirement.restrictionLevel();
    }

    private String explain(Feature functionality) {
        return String.format("%s v.%s", functionality.name(), functionality.version());
    }

    private String explain(TroubleCode trouble) {
        return String.format("%s (%d)", trouble.explanation(), trouble.code());
    }

    String feature() {
        return this.feature;
    }

    String status() {
        return this.status;
    }

    RestrictionLevel level() {
        return this.level;
    }
}

