/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lbc.internal.base.acquire.AvailableForUser;
import org.eclipse.passage.lbc.internal.base.acquire.LicensePacks;
import org.eclipse.passage.lic.floating.model.api.FeatureGrant;
import org.eclipse.passage.lic.floating.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;

final class FeatureGrants {
    private final LicensedProduct product;
    private final String user;
    private final String feature;
    private final Supplier<Path> base;

    FeatureGrants(LicensedProduct product, String user, String feature, Supplier<Path> base) {
        this.product = product;
        this.user = user;
        this.feature = feature;
        this.base = base;
    }

    Collection<FeatureGrant> get() throws LicensingException {
        return new LicensePacks(this.product, this.base).get().stream().filter(new AvailableForUser(this.user)).map(this::grantForFeature).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<FeatureGrant> grantForFeature(FloatingLicensePack license) {
        return license.getFeatures().stream().filter(grant -> this.feature.equals(grant.getFeature())).findAny();
    }
}

