/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lbc.internal.base.api.RawRequest;
import org.eclipse.passage.lbc.internal.base.mine.FloatingConditions;
import org.eclipse.passage.lbc.internal.base.mine.PersonalLicenseGenerated;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.PassageAction;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.internal.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.handle.EObjectTransfer;
import org.eclipse.passage.lic.internal.net.handle.Failure;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;

public final class Conditions
implements Supplier<NetResponse> {
    private final ProductUserRequest<RawRequest> data;
    private final Supplier<Path> source;
    private final Logger log = LogManager.getLogger(this.getClass());

    public Conditions(ProductUserRequest<RawRequest> data, Supplier<Path> base) {
        this.data = data;
        this.source = base;
    }

    public Conditions(ProductUserRequest<RawRequest> data) {
        this(data, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    @Override
    public NetResponse get() {
        this.log.debug(String.format("Mining conditions for product %s", this.data.product().get()));
        ServiceInvocationResult conditions = new FloatingConditions(this.source, (String)this.data.user().get()).all((LicensedProduct)this.data.product().get());
        if (!conditions.data().isPresent()) {
            return new Failure.OperationFailed(new PassageAction.Mine().name(), new DiagnosticExplained(conditions.diagnostic()).get());
        }
        if (!new NoErrors().test(conditions.diagnostic())) {
            this.log.error(new DiagnosticExplained(conditions.diagnostic()).get());
        }
        return new EObjectTransfer((EObject)this.pack((Collection)conditions.data().get()));
    }

    private LicensePack pack(Collection<ConditionPack> conditions) {
        return new PersonalLicenseGenerated((LicensedProduct)this.data.product().get(), (String)this.data.user().get(), conditions.stream().flatMap(pack -> pack.conditions().stream()).collect(Collectors.toList())).get();
    }
}

