/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.interaction;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.base.interaction.OnlyFileOfType;
import org.eclipse.passage.lbc.internal.base.interaction.Pack;
import org.eclipse.passage.lic.floating.FloatingFileExtension;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoDataOfType;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;

final class PacksFound
implements Supplier<ServiceInvocationResult<Collection<Pack>>> {
    private final Path source;
    private final String flicen = new FloatingFileExtension.FloatingLicenseEncrypted().get();
    private final String pub = new PassageFileExtension.PublicKey().get();

    public PacksFound(Path source) {
        this.source = source;
    }

    @Override
    public ServiceInvocationResult<Collection<Pack>> get() {
        ArrayList<ServiceInvocationResult<Collection<Pack>>> packs = new ArrayList<ServiceInvocationResult<Collection<Pack>>>();
        this.searchThroughDirectory(this.source.toFile(), packs);
        if (packs.isEmpty()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new NoDataOfType(), "floating license"));
        }
        return (ServiceInvocationResult)packs.stream().reduce(new BaseServiceInvocationResult(Collections.emptyList()), new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections()));
    }

    private void searchThroughDirectory(File parent, List<ServiceInvocationResult<Collection<Pack>>> packs) {
        File[] fileArray = parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.searchThroughDirectory(file, packs);
            } else {
                this.maybePack(file).ifPresent(packs::add);
            }
            ++n2;
        }
    }

    private Optional<ServiceInvocationResult<Collection<Pack>>> maybePack(File license) {
        Path key;
        if (!license.getName().endsWith(this.flicen)) {
            return Optional.empty();
        }
        try {
            key = new OnlyFileOfType(license.getParentFile().toPath(), this.pub).get();
        }
        catch (Exception e) {
            return Optional.of(this.failToFindKey(license, e));
        }
        return Optional.of(this.packIndeed(license, key));
    }

    private ServiceInvocationResult<Collection<Pack>> packIndeed(File license, Path key) {
        return new BaseServiceInvocationResult(Collections.singletonList(new Pack(license.toPath(), key)));
    }

    private ServiceInvocationResult<Collection<Pack>> failToFindKey(File license, Exception e) {
        Trouble error = new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format("Failed to find public key for license file %s", license.getAbsolutePath()), e);
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.singletonList(error)));
    }
}

