/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;

public final class ExternalLicense {
    private final Path destination;

    public ExternalLicense(LicensedProduct product) {
        this(new PathFromLicensedProduct(new LicensingFolder(new UserHomePath()), product).get());
    }

    public ExternalLicense(Path base, LicensedProduct product) {
        this(new PathFromLicensedProduct(() -> base, product).get());
    }

    public ExternalLicense(Path destination) {
        this.destination = destination;
    }

    public Path install(Path ... pack) throws IOException {
        Path[] pathArray = pack;
        int n = pack.length;
        int n2 = 0;
        while (n2 < n) {
            Path file = pathArray[n2];
            this.installLicenseFile(file);
            ++n2;
        }
        return this.destination;
    }

    private void installLicenseFile(Path file) throws IOException {
        Path target = this.destination.resolve(file.getFileName());
        target.toFile().getParentFile().mkdirs();
        Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
    }
}

