/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.StringNamedData;
import org.eclipse.passage.lic.internal.base.io.Settings;
import org.eclipse.passage.lic.internal.net.HostPort;
import org.eclipse.passage.lic.internal.net.LicensingServerCoordinates;
import org.eclipse.passage.lic.internal.net.LicensingServerHost;
import org.eclipse.passage.lic.internal.net.LicensingServerPort;
import org.eclipse.passage.lic.internal.net.i18n.NetMessages;

public final class LicensingServerCoordinatesFromSettings
implements LicensingServerCoordinates {
    private final Supplier<Path> settings;

    public LicensingServerCoordinatesFromSettings(Supplier<Path> residence) {
        this.settings = residence;
    }

    @Override
    public HostPort get() throws LicensingException {
        Map properties = new Settings(this.settings, this::necessaryPropertiesExist).get();
        return new HostPort(this.value(new LicensingServerHost(properties)), this.value(new LicensingServerPort(properties)));
    }

    private String value(StringNamedData data) throws LicensingException {
        Optional value = data.get();
        if (!value.isPresent()) {
            throw new LicensingException(String.format(NetMessages.getString("LicensingServerCoordinatesFromSettings.settings_not_found"), data.key()));
        }
        if (((String)value.get()).trim().isEmpty()) {
            throw new LicensingException(String.format(NetMessages.getString("LicensingServerCoordinatesFromSettings.settings_are_blank"), data.key()));
        }
        return (String)value.get();
    }

    private boolean necessaryPropertiesExist(Map<String, Object> properties) {
        return new LicensingServerHost(properties).get().isPresent() && new LicensingServerPort(properties).get().isPresent();
    }
}

