/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.internal.api.conditions.mining.LicenseReadingService;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.internal.base.io.ExternalLicense;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.equinox.LicenseReadingServiceRequest;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereTable;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.NotificationDialog;
import org.eclipse.passage.lic.internal.jface.i18n.ImportLicenseDialogMessages;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ImportLicenseDialog
extends NotificationDialog {
    private final DateTimeFormatter dates = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private ButtonConfig action;
    private Text path;

    public ImportLicenseDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ImportLicenseDialogMessages.ImportLicenseDialog_title);
        shell.setImage(LicensingImages.getImage("IMG_IMPORT"));
        shell.setSize(850, 500);
    }

    @Override
    protected void buildUI(Composite parent) {
        this.buildSelector(parent);
        this.buildViewer(parent);
    }

    @Override
    protected void initMessage() {
        this.setMessage(ImportLicenseDialogMessages.ImportLicenseDialog_prelude);
    }

    private void buildSelector(Composite parent) {
        Composite composite = this.row(parent, 3);
        new Label(composite, 0).setText(ImportLicenseDialogMessages.ImportLicenseDialog_path_label);
        this.path = new Text(composite, 2056);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browse = new Button(composite, 8);
        browse.setText("B&rowse...");
        browse.addListener(13, e -> this.browseAndLoad());
        this.setButtonLayoutData(browse);
    }

    private Composite row(Composite parent, int columns) {
        Composite row = new Composite(parent, 0);
        row.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        row.setLayout((Layout)new GridLayout(columns, false));
        return row;
    }

    private void buildViewer(Composite parent) {
        this.viewer = new HereTable<Condition>(parent, Condition.class).withColumn(ImportLicenseDialogMessages.ImportLicenseDialog_column_feature, 300, this::feature).withColumn(ImportLicenseDialogMessages.ImportLicenseDialog_column_period, 300, this::period).withColumn(ImportLicenseDialogMessages.ImportLicenseDialog_column_evaluation, 210, this::evaluation).viewer();
    }

    private String feature(Condition condition) {
        return String.format("%s version %s (%s)", condition.feature(), condition.versionMatch().version(), condition.versionMatch().rule().identifier());
    }

    private String period(Condition condition) {
        ValidityPeriod period = condition.validityPeriod();
        if (!BaseValidityPeriodClosed.class.isInstance(period)) {
            return "unknown";
        }
        BaseValidityPeriodClosed closed = (BaseValidityPeriodClosed)condition.validityPeriod();
        return String.format("%s - %s", this.dates.format(closed.from()), this.dates.format(closed.to()));
    }

    private String evaluation(Condition condition) {
        return String.format("%s (%s)", condition.evaluationInstructions().expression(), condition.evaluationInstructions().type().identifier());
    }

    private void browseAndLoad() {
        this.browse().ifPresent(this::loadLicense);
        this.updateButtonsEnablement();
    }

    private Optional<String> browse() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText(ImportLicenseDialogMessages.ImportLicenseDialog_browse_dialog_title);
        dialog.setFilterPath(this.path.getText().trim());
        dialog.setFilterExtensions(new String[]{"*.licen", "*.*"});
        Optional<String> file = Optional.ofNullable(dialog.open());
        file.ifPresent(arg_0 -> ((Text)this.path).setText(arg_0));
        return file;
    }

    private void loadLicense(String file) {
        ServiceInvocationResult reader = new LicenseReadingServiceRequest().get();
        if (!reader.data().isPresent()) {
            this.reportError(reader.diagnostic());
            return;
        }
        ServiceInvocationResult packs = ((LicenseReadingService)reader.data().get()).read(Paths.get(file, new String[0]));
        if (!packs.data().isPresent()) {
            this.reportError(packs.diagnostic());
            return;
        }
        List conditions = ((Collection)packs.data().get()).stream().flatMap(pack -> pack.conditions().stream()).collect(Collectors.toList());
        this.viewer.setInput(conditions);
    }

    private void reportError(Diagnostic diagnostic) {
        this.setErrorMessage(ImportLicenseDialogMessages.ImportLicenseDialog_lic_read_failed);
        new DiagnosticDialog(this.getShell(), diagnostic).open();
    }

    @Override
    protected void initButtons() {
        this.action = new ButtonConfig(1, this::doLicenseImport, ImportLicenseDialogMessages.ImportLicenseDialog_import_title, ImportLicenseDialogMessages.ImportLicenseDialog_import_tooltip, "");
        this.action.reside(this.buttons);
    }

    @Override
    protected void inplaceData() {
        this.viewer.setInput(Collections.emptyList());
    }

    @Override
    protected void updateButtonsEnablement() {
        this.getButton(this.action.id()).setEnabled(!((Collection)this.viewer.getInput()).isEmpty());
    }

    private void doLicenseImport() {
        ServiceInvocationResult product = new EquinoxPassage().product();
        if (!product.data().isPresent()) {
            this.reportError(product.diagnostic());
            return;
        }
        try {
            new ExternalLicense((LicensedProduct)product.data().get()).install(new Path[]{Paths.get(this.path.getText().trim(), new String[0])});
        }
        catch (IOException e) {
            this.setErrorMessage(String.format(ImportLicenseDialogMessages.ImportLicenseDialog_io_error, e.getLocalizedMessage()));
        }
        this.okPressed();
    }
}

