/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.fls.seal;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.AccessCycleConfiguration;
import org.eclipse.passage.lic.internal.api.EvaluationType;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluationService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluatorsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionPasringRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionTokenAssessmentService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionTokenAssessorsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.PermissionEmittersRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransportRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.internal.api.inspection.RuntimeEnvironment;
import org.eclipse.passage.lic.internal.api.inspection.RuntimeEnvironmentRegistry;
import org.eclipse.passage.lic.internal.api.io.Hashes;
import org.eclipse.passage.lic.internal.api.io.HashesRegistry;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodec;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirementsRegistry;
import org.eclipse.passage.lic.internal.api.restrictions.PermissionsExaminationService;
import org.eclipse.passage.lic.internal.api.restrictions.PermissionsExaminationServicesRegistry;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.BasePermissionEmittingService;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.BerlinProtocolExpressionParseService;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.SimpleMapExpressionEvaluationService;
import org.eclipse.passage.lic.internal.base.conditions.mining.PersonalLicenseMiningEquipment;
import org.eclipse.passage.lic.internal.base.registry.ReadOnlyRegistry;
import org.eclipse.passage.lic.internal.base.restrictions.BasePermissionsExaminationService;
import org.eclipse.passage.lic.internal.bc.BcStreamCodec;
import org.eclipse.passage.lic.internal.equinox.io.BundleKeyKeeper;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleRequirements;
import org.eclipse.passage.lic.internal.equinox.requirements.ComponentRequirements;
import org.eclipse.passage.lic.internal.licenses.model.toberemoved.XmiConditionTransport;
import org.eclipse.passage.lic.internal.oshi.HardwareAssessmentService;
import org.eclipse.passage.lic.internal.oshi.HardwareEnvironment;
import org.osgi.framework.Bundle;

abstract class BaseAccessCycleConfiguration
implements AccessCycleConfiguration {
    private final Registry<StringServiceId, ResolvedRequirements> requirements = new ReadOnlyRegistry(Arrays.asList(new BundleRequirements(), new ComponentRequirements()));
    private final Registry<ContentType, ConditionTransport> transports = new ReadOnlyRegistry(Arrays.asList(new XmiConditionTransport()));
    private final Registry<LicensedProduct, StreamCodec> codecs;
    private final Registry<LicensedProduct, KeyKeeper> keys;
    private final Registry<StringServiceId, PermissionEmittingService> emitters;
    private final Registry<ExpressionProtocol, ExpressionParsingService> expressionParsers;
    private final Registry<ExpressionProtocol, ExpressionEvaluationService> expressionEvaluators;
    private final Registry<EvaluationType, ExpressionTokenAssessmentService> tokenAssessors;
    private final Registry<EvaluationType, RuntimeEnvironment> environments;
    private final Registry<StringServiceId, PermissionsExaminationService> examinators;
    private final Registry<StringServiceId, Hashes> hashes;

    protected BaseAccessCycleConfiguration(Supplier<LicensedProduct> product, Supplier<Bundle> bundle) {
        this.codecs = new ReadOnlyRegistry(Arrays.asList(new BcStreamCodec(product)));
        this.keys = new ReadOnlyRegistry(Arrays.asList(new BundleKeyKeeper(product, bundle.get())));
        this.emitters = new ReadOnlyRegistry(Arrays.asList(new BasePermissionEmittingService(this.expressionParsers(), this.expressionAssessors(), this.expressionEvaluators())));
        this.expressionParsers = new ReadOnlyRegistry(Arrays.asList(new BerlinProtocolExpressionParseService()));
        this.expressionEvaluators = new ReadOnlyRegistry(Arrays.asList(new SimpleMapExpressionEvaluationService()));
        this.tokenAssessors = new ReadOnlyRegistry(Arrays.asList(new HardwareAssessmentService(this.environments())));
        this.environments = new ReadOnlyRegistry(Arrays.asList(new HardwareEnvironment()));
        this.examinators = new ReadOnlyRegistry(Arrays.asList(new BasePermissionsExaminationService()));
        this.hashes = new ReadOnlyRegistry(Collections.emptyList());
    }

    public final MiningEquipment miningEquipment() {
        return new PersonalLicenseMiningEquipment(this.keyKeepers(), this.codecs(), this.transports());
    }

    public final ResolvedRequirementsRegistry requirementResolvers() {
        return () -> this.requirements;
    }

    public final StreamCodecRegistry codecs() {
        return () -> this.codecs;
    }

    public final KeyKeeperRegistry keyKeepers() {
        return () -> this.keys;
    }

    public final ConditionTransportRegistry transports() {
        return () -> this.transports;
    }

    public final PermissionEmittersRegistry permissionEmitters() {
        return () -> this.emitters;
    }

    public final ExpressionPasringRegistry expressionParsers() {
        return () -> this.expressionParsers;
    }

    public final ExpressionEvaluatorsRegistry expressionEvaluators() {
        return () -> this.expressionEvaluators;
    }

    public final ExpressionTokenAssessorsRegistry expressionAssessors() {
        return () -> this.tokenAssessors;
    }

    public final RuntimeEnvironmentRegistry environments() {
        return () -> this.environments;
    }

    public final PermissionsExaminationServicesRegistry examinators() {
        return () -> this.examinators;
    }

    public HashesRegistry hashes() {
        return () -> this.hashes;
    }
}

