/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;

final class LinuxFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;
    private static final String SYSFS_SERIAL_PATH = "/sys/devices/virtual/dmi/id/";

    LinuxFirmware() {
        this.init();
    }

    private void init() {
        String biosDate;
        String biosVersion;
        String modalias;
        String biosVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_vendor");
        if (biosVendor != null && !biosVendor.trim().isEmpty()) {
            this.setManufacturer(biosVendor.trim());
        }
        if ((modalias = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/modalias")) != null && !modalias.trim().isEmpty()) {
            this.setDescription(modalias.trim());
        }
        if ((biosVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_version")) != null && !biosVersion.trim().isEmpty()) {
            String marker = "Bios Revision:";
            String biosRevision = null;
            for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
                if (!checkLine.contains("Bios Revision:")) continue;
                biosRevision = checkLine.split("Bios Revision:")[1].trim();
                break;
            }
            if (biosRevision != null && !biosRevision.trim().isEmpty()) {
                this.setVersion(biosVersion.trim() + " (revision " + biosRevision + ")");
            } else {
                this.setVersion(biosVersion.trim());
            }
        }
        if ((biosDate = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/bios_date")) != null && !biosDate.trim().isEmpty()) {
            try {
                this.setReleaseDate(String.format("%s-%s-%s", biosDate.substring(6, 10), biosDate.substring(0, 2), biosDate.substring(3, 5)));
            }
            catch (StringIndexOutOfBoundsException e) {
                this.setReleaseDate(biosDate);
            }
        }
    }
}

