/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.licenses.model.util.LicensesResourceImpl;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.Licenses;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.equinox.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicensesDomainRegistryTracker;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=licenses", "org.eclipse.passage.lic.emf.edit.file.extension=licenses_xmi"})
public final class LicenseDomainRegistry
extends BaseDomainRegistry<LicensePlan>
implements LicenseRegistry,
EditingDomainRegistry<LicensePlan> {
    private final Map<String, LicensePlan> plans = new HashMap<String, LicensePlan>();
    private final List<EventAdmin> events = new ArrayList<EventAdmin>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindEventAdmin(EventAdmin admin) {
        this.events.add(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events.remove(admin);
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    @Activate
    public void load(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void unload(Map<String, Object> properties) {
        this.plans.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "licenses_xmi";
    }

    public Class<LicensePlan> getContentClass() {
        return LicensePlan.class;
    }

    public String resolveIdentifier(LicensePlan content) {
        return content.getIdentifier();
    }

    @Override
    public Collection<LicensePlan> plans() {
        return new ArrayList<LicensePlan>(this.plans.values());
    }

    @Override
    public Optional<LicensePlan> plan(String identifier) {
        return Optional.ofNullable(this.plans.get(identifier));
    }

    void registerLicensePlan(LicensePlan licensePlan) {
        String identifier = licensePlan.getIdentifier();
        LicensePlan existing = this.plans.put(identifier, licensePlan);
        if (existing != null && existing != licensePlan) {
            String msg = NLS.bind((String)LicensesCoreMessages.LicenseDomain_instance_duplication_message, (Object)existing, (Object)licensePlan);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/licenses/registry/LicensePlan/create", (Object)licensePlan).get());
    }

    void unregisterLicensePlan(String identifier) {
        LicensePlan removed = this.plans.remove(identifier);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/licenses/registry/LicensePlan/delete", (Object)removed).get());
        }
    }

    private EventAdmin events() {
        return (EventAdmin)this.events.stream().findAny().get();
    }

    protected DomainContentAdapter<LicensePlan, LicenseDomainRegistry> createContentAdapter() {
        return new LicensesDomainRegistryTracker(this);
    }

    public EClass getContentClassifier() {
        return LicensesPackage.eINSTANCE.getLicensePlan();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePlan_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePlan_Name();
    }

    public void registerContent(LicensePlan content) {
        this.registerLicensePlan(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterLicensePlan(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new LicensesResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Licenses.xmi.equals(handle.type()) || Licenses.xmi033.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.licenses();
    }
}

