/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.MailData;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.MailInputValidator;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.SMTPHostString;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MailDialog
extends FormDialog {
    private static final int MIN_X_WIN_SIZE = 700;
    private static final int MIN_Y_WIN_SIZE = 425;
    private Text fDestinationsInputTextField = null;
    private Text fSubjectInputTextField = null;
    protected Text fMessageBodyInputTextField = null;
    private String fAttachment = null;
    private MailData fMailData = null;
    private final IInputValidator fValidator;

    public MailDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(true);
        this.fValidator = new MailInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String validateResult = this.validateEmptyInput(this.fDestinationsInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("to_Error"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, validateResult, null), 4);
                dialog.open();
                this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
                return;
            }
            String[] destinationValues = this.fDestinationsInputTextField.getText().split(";");
            validateResult = this.validateEmptyInput(this.fSubjectInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("subject_Error"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, validateResult, null), 4);
                dialog.open();
                this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
                return;
            }
            String subjectValue = this.fSubjectInputTextField.getText();
            validateResult = this.validateEmptyInput(this.fMessageBodyInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("message_body_Error"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, validateResult, null), 4);
                dialog.open();
                this.getShell().setCursor(this.getShell().getDisplay().getSystemCursor(0));
                return;
            }
            String messageBodyValue = this.fMessageBodyInputTextField.getText();
            this.fMailData = new MailData(subjectValue, messageBodyValue, destinationValues, this.fAttachment);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SMTPHostString.getString("MailDialog.label.title"));
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 3;
        composite.setLayout((Layout)layout);
        this.createMailForm(composite, toolkit);
        this.getShell().setMinimumSize(700, 425);
    }

    private void createMailForm(Composite aParent, FormToolkit aToolkit) {
        Composite mailForm = aToolkit.createComposite(aParent);
        mailForm.setBackground(this.getShell().getDisplay().getSystemColor(1));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 3;
        mailForm.setLayout((Layout)layout);
        FormData mailFormData = new FormData();
        mailFormData.top = new FormAttachment(0, 0);
        mailFormData.left = new FormAttachment(0);
        mailFormData.right = new FormAttachment(100);
        mailFormData.bottom = new FormAttachment(100);
        mailForm.setLayoutData((Object)mailFormData);
        Label destinationsLabel = aToolkit.createLabel(mailForm, SMTPHostString.getString("MailDialog.label.toLabel"), 0);
        destinationsLabel.setToolTipText(SMTPHostString.getString("MailDialog.label.toLabel.tooltip"));
        FormData destinationsLabelData = new FormData();
        destinationsLabelData.top = new FormAttachment(0, 2);
        destinationsLabelData.left = new FormAttachment(0);
        destinationsLabel.setLayoutData((Object)destinationsLabelData);
        this.fDestinationsInputTextField = aToolkit.createText(mailForm, "", 2048);
        this.fDestinationsInputTextField.setEnabled(true);
        FormData toTextData = new FormData();
        toTextData.top = new FormAttachment(0);
        toTextData.left = new FormAttachment((Control)destinationsLabel, 34);
        toTextData.right = new FormAttachment(98);
        this.fDestinationsInputTextField.setLayoutData((Object)toTextData);
        Label subjectLabel = aToolkit.createLabel(mailForm, SMTPHostString.getString("MailDialog.label.subjectLabel"), 0);
        subjectLabel.setToolTipText(SMTPHostString.getString("MailDialog.label.subjectLabel.tooltip"));
        FormData subjectLabelData = new FormData();
        subjectLabelData.top = new FormAttachment((Control)destinationsLabel, 15, 1024);
        subjectLabelData.left = new FormAttachment(0);
        subjectLabel.setLayoutData((Object)subjectLabelData);
        this.fSubjectInputTextField = aToolkit.createText(mailForm, "", 2048);
        FormData subjectData = new FormData();
        subjectData.top = new FormAttachment((Control)this.fDestinationsInputTextField, 10, 1024);
        subjectData.left = new FormAttachment((Control)subjectLabel, 10);
        subjectData.right = new FormAttachment(98);
        this.fSubjectInputTextField.setLayoutData((Object)subjectData);
        this.fMessageBodyInputTextField = new Text(mailForm, 2818);
        FormData messageBodyEditorData = new FormData();
        messageBodyEditorData.top = new FormAttachment((Control)subjectLabel, 15, 1024);
        messageBodyEditorData.left = new FormAttachment(0);
        messageBodyEditorData.right = new FormAttachment(98);
        messageBodyEditorData.bottom = new FormAttachment(98);
        this.fMessageBodyInputTextField.setLayoutData((Object)messageBodyEditorData);
        mailForm.setSize(700, 425);
        FormData data = (FormData)this.fDestinationsInputTextField.getLayoutData();
        data.left = new FormAttachment((Control)this.fSubjectInputTextField, 0, 16384);
        this.fDestinationsInputTextField.setLayoutData((Object)data);
    }

    protected boolean isResizable() {
        return true;
    }

    public MailData getEmailData() {
        return this.fMailData;
    }

    public void setMailInfo(String[] aDestinations, String aSubject, String aMessageBody, String aAttachment) {
        StringBuilder recipient = new StringBuilder();
        int i = 0;
        while (i < aDestinations.length) {
            recipient.append(aDestinations[i]);
            if (i < aDestinations.length - 1) {
                recipient.append(';');
            }
            ++i;
        }
        this.fDestinationsInputTextField.setText(recipient.toString());
        this.fSubjectInputTextField.setText(aSubject);
        this.fMessageBodyInputTextField.setText(aMessageBody);
        this.fAttachment = aAttachment;
    }

    private String validateEmptyInput(Text aText) {
        if (this.fValidator != null) {
            return this.fValidator.isValid(aText.getText());
        }
        return null;
    }
}

