/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.EditableListWidget;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.IEditableListListener;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ParticipantTabPropertySection
extends ModelElementTabPropertySection
implements IEditableListListener {
    private static final String USER_DETAILS_LABEL = "User Details";
    private static final String ROLE_SECTION_LABEL = "Role Management";
    private static final String TIME_SECTION_LABEL = "Time Management";
    private Text fIdText = null;
    protected Text fEmailText = null;
    private Text fNumItemsText = null;
    private Text fNumAnomaliesText = null;
    private Text fNumCommentsText = null;
    private Text fDetailsText = null;
    private ExpandableComposite fTimeSection = null;
    protected EditableListWidget fTimeSpentDetailedList = null;
    private ExpandableComposite fRolesSection = null;
    private EditableListWidget fRolesList = null;
    protected Text fFocusAreaText = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite mainForm = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fIdText = widgetFactory.createText(mainForm, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fIdText.setEditable(false);
        this.fIdText.setToolTipText("A Tag that Identifies this Participant");
        this.fIdText.setLayoutData((Object)data);
        CLabel idLabel = widgetFactory.createCLabel(mainForm, "Id: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fIdText, -5);
        data.top = new FormAttachment((Control)this.fIdText, 0, 0x1000000);
        idLabel.setToolTipText("A Tag that Identifies this Participant");
        idLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fEmailText = widgetFactory.createText(mainForm, "");
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fIdText, 4);
        this.fEmailText.setToolTipText("The Email Address for the Participant");
        this.fEmailText.setLayoutData((Object)data);
        this.fEmailText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ParticipantTabPropertySection.this.fRefreshInProgress && ParticipantTabPropertySection.this.fEmailText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String newValue = ParticipantTabPropertySection.this.fEmailText.getText().trim();
                        if (!CommandUtils.isEmailValid(newValue)) {
                            return;
                        }
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EParticipant modelParticipant = ((R4EUIParticipant)ParticipantTabPropertySection.this.fProperties.getElement()).getParticipant();
                        if (!newValue.equals(modelParticipant.getEmail())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, currentUser);
                            modelParticipant.setEmail(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ParticipantTabPropertySection.this.fEmailText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fEmailText);
        CLabel emailLabel = widgetFactory.createCLabel(mainForm, "Email: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fEmailText, -5);
        data.top = new FormAttachment((Control)this.fEmailText, 0, 0x1000000);
        emailLabel.setToolTipText("The Email Address for the Participant");
        emailLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(0);
        this.fNumItemsText = widgetFactory.createText(mainForm, "", 0);
        this.fNumItemsText.setBackground(Display.getDefault().getSystemColor(19));
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fIdText, 4);
        this.fNumItemsText.setEditable(false);
        this.fNumItemsText.setToolTipText("Number of Review Items added by this Participant");
        this.fNumItemsText.setLayoutData((Object)data);
        CLabel numItemsLabel = widgetFactory.createCLabel(mainForm, "Review Items Added: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fNumItemsText, -5);
        data.top = new FormAttachment((Control)this.fNumItemsText, 0, 0x1000000);
        numItemsLabel.setToolTipText("Number of Review Items added by this Participant");
        numItemsLabel.setLayoutData((Object)data);
        this.fNumAnomaliesText = widgetFactory.createText(mainForm, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fNumItemsText, 4);
        this.fNumAnomaliesText.setEditable(false);
        this.fNumAnomaliesText.setToolTipText("Number of Anomlaies added by this Participant");
        this.fNumAnomaliesText.setLayoutData((Object)data);
        CLabel numAnomaliesLabel = widgetFactory.createCLabel(mainForm, "Anomalies Added: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fNumAnomaliesText, -5);
        data.top = new FormAttachment((Control)this.fNumAnomaliesText, 0, 0x1000000);
        numAnomaliesLabel.setToolTipText("Number of Anomlaies added by this Participant");
        numAnomaliesLabel.setLayoutData((Object)data);
        this.fNumCommentsText = widgetFactory.createText(mainForm, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fNumAnomaliesText, 4);
        this.fNumCommentsText.setEditable(false);
        this.fNumCommentsText.setToolTipText("Number of Comments (other than Anomalies) added by this Participant");
        this.fNumCommentsText.setLayoutData((Object)data);
        CLabel numCommentsLabel = widgetFactory.createCLabel(mainForm, "Comments Added: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fNumCommentsText, -5);
        data.top = new FormAttachment((Control)this.fNumCommentsText, 0, 0x1000000);
        numCommentsLabel.setToolTipText("Number of Comments (other than Anomalies) added by this Participant");
        numCommentsLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fFocusAreaText = widgetFactory.createText(mainForm, "");
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fNumCommentsText, 4);
        this.fFocusAreaText.setToolTipText("The Focus Area for this Participant.  A Focus Area is Defined by Specific Aspects of the Review this Participant should Focus his Attention to");
        this.fFocusAreaText.setLayoutData((Object)data);
        this.fFocusAreaText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ParticipantTabPropertySection.this.fRefreshInProgress && ParticipantTabPropertySection.this.fFocusAreaText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EParticipant modelParticipant = ((R4EUIParticipant)ParticipantTabPropertySection.this.fProperties.getElement()).getParticipant();
                        String newValue = ParticipantTabPropertySection.this.fFocusAreaText.getText().trim();
                        if (!newValue.equals(modelParticipant.getFocusArea())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, currentUser);
                            modelParticipant.setFocusArea(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ParticipantTabPropertySection.this.fFocusAreaText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fFocusAreaText);
        CLabel focusAreaLabel = widgetFactory.createCLabel(mainForm, "Focus Area: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fFocusAreaText, -5);
        data.top = new FormAttachment((Control)this.fFocusAreaText, 0, 0x1000000);
        focusAreaLabel.setToolTipText("The Focus Area for this Participant.  A Focus Area is Defined by Specific Aspects of the Review this Participant should Focus his Attention to");
        focusAreaLabel.setLayoutData((Object)data);
        this.createDetailsSections(widgetFactory, mainForm);
    }

    private void createDetailsSections(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite) {
        ExpandableComposite partDetailsSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fFocusAreaText, 4);
        partDetailsSection.setLayoutData((Object)data);
        partDetailsSection.setText(USER_DETAILS_LABEL);
        partDetailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        partDetailsSection.setLayout((Layout)new GridLayout(1, false));
        Composite partDetailsSectionClient = aWidgetFactory.createComposite((Composite)partDetailsSection);
        partDetailsSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        partDetailsSectionClient.setLayout((Layout)new GridLayout(4, false));
        partDetailsSection.setClient((Control)partDetailsSectionClient);
        CLabel detailsLabel = aWidgetFactory.createCLabel(partDetailsSectionClient, "User Details: ");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 1;
        detailsLabel.setToolTipText("Extra Information about this Participant");
        detailsLabel.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(0);
        this.fDetailsText = aWidgetFactory.createText(partDetailsSectionClient, "", 2);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        this.fDetailsText.setEditable(false);
        this.fDetailsText.setToolTipText("Extra Information about this Participant");
        this.fDetailsText.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(2048);
        this.fRolesSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)partDetailsSection, 4);
        this.fRolesSection.setLayoutData((Object)data);
        this.fRolesSection.setText(ROLE_SECTION_LABEL);
        this.fRolesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        this.fRolesSection.setLayout((Layout)new GridLayout(1, false));
        Composite rolesSectionClient = aWidgetFactory.createComposite((Composite)this.fRolesSection);
        rolesSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        rolesSectionClient.setLayout((Layout)new GridLayout(4, false));
        this.fRolesSection.setClient((Control)rolesSectionClient);
        CLabel rolesLabel = aWidgetFactory.createCLabel(rolesSectionClient, "Roles: ");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 1;
        rolesLabel.setToolTipText("The Roles this Participant holds for the Current Review.  Roles are used to Manage the Actions the Participant can do");
        rolesLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        this.fRolesList = new EditableListWidget((FormToolkit)aWidgetFactory, rolesSectionClient, gridData, this, 2, CCombo.class, R4EUIConstants.PARTICIPANT_ROLES);
        this.fRolesList.setToolTipText("The Roles this Participant holds for the Current Review.  Roles are used to Manage the Actions the Participant can do");
        this.fTimeSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fRolesSection, 4);
        data.bottom = new FormAttachment(100, 0);
        this.fTimeSection.setLayoutData((Object)data);
        this.fTimeSection.setText(TIME_SECTION_LABEL);
        this.fTimeSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        this.fTimeSection.setLayout((Layout)new GridLayout(1, false));
        Composite timeSectionClient = aWidgetFactory.createComposite((Composite)this.fTimeSection);
        timeSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        timeSectionClient.setLayout((Layout)new GridLayout(4, false));
        this.fTimeSection.setClient((Control)timeSectionClient);
        CLabel timeSpentDetailedLabel = aWidgetFactory.createCLabel(timeSectionClient, "Time Spent: ");
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 1;
        timeSpentDetailedLabel.setToolTipText("The time the Participant spent working on this Review");
        timeSpentDetailedLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        this.fTimeSpentDetailedList = new EditableListWidget((FormToolkit)aWidgetFactory, timeSectionClient, gridData, this, 1, Date.class, null);
        this.fTimeSpentDetailedList.setToolTipText("The time the Participant spent working on this Review");
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        R4EParticipant modelUser = ((R4EUIParticipant)this.fProperties.getElement()).getParticipant();
        this.fIdText.setText(modelUser.getId());
        String email = modelUser.getEmail();
        if (email != null) {
            this.fEmailText.setText(email);
        } else {
            this.fEmailText.setText("");
        }
        this.fNumItemsText.setText(String.valueOf(modelUser.getAddedItems().size()));
        int numAnomalies = 0;
        int numComments = 0;
        EList comments = modelUser.getAddedComments();
        int commentsSize = comments.size();
        int i = 0;
        while (i < commentsSize) {
            if (comments.get(i) instanceof R4EAnomaly) {
                ++numAnomalies;
            } else {
                ++numComments;
            }
            ++i;
        }
        this.fNumAnomaliesText.setText(String.valueOf(numAnomalies));
        this.fNumCommentsText.setText(String.valueOf(numComments));
        String details = ((R4EUIParticipant)this.fProperties.getElement()).getParticipantDetails();
        if (details != null) {
            this.fDetailsText.setText(details);
        } else {
            this.fDetailsText.setText("");
        }
        int numTimeEntries = modelUser.getTimeLog().size();
        this.fTimeSpentDetailedList.removeAll();
        int totalTimeSpent = 0;
        Item item = null;
        Map.Entry timeEntry = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        int i2 = 0;
        while (i2 < numTimeEntries) {
            timeEntry = (Map.Entry)modelUser.getTimeLog().get(i2);
            if (i2 >= this.fTimeSpentDetailedList.getItemCount()) {
                item = this.fTimeSpentDetailedList.addItem();
            } else {
                item = this.fTimeSpentDetailedList.getItem(i2);
                if (item == null) {
                    item = this.fTimeSpentDetailedList.addItem();
                }
            }
            String[] data = new String[]{((Integer)timeEntry.getValue()).toString(), dateFormat.format((Date)timeEntry.getKey())};
            ((TableItem)item).setText(data);
            totalTimeSpent += ((Integer)timeEntry.getValue()).intValue();
            ++i2;
        }
        this.fTimeSpentDetailedList.setTableHeader(0, "Time Spent: " + Integer.toString(totalTimeSpent) + " minutes");
        this.fTimeSpentDetailedList.updateButtons();
        String[] roles = ((R4EUIParticipant)this.fProperties.getElement()).getRoles((EList<R4EUserRole>)modelUser.getRoles());
        this.fRolesList.removeAll();
        String role = null;
        int i3 = 0;
        while (i3 < roles.length) {
            role = roles[i3];
            if (i3 >= this.fRolesList.getItemCount()) {
                item = this.fRolesList.addItem();
            } else {
                item = this.fRolesList.getItem(i3);
                if (item == null) {
                    item = this.fRolesList.addItem();
                }
            }
            item.setText(role);
            ++i3;
        }
        this.fRolesList.updateButtons();
        String focusArea = modelUser.getFocusArea();
        if (focusArea != null) {
            this.fFocusAreaText.setText(focusArea);
        } else {
            this.fFocusAreaText.setText("");
        }
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fIdText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fEmailText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fEmailText.setEditable(false);
            this.fNumItemsText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fNumAnomaliesText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fNumCommentsText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDetailsText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fTimeSpentDetailedList.setEnabled(false);
            this.fRolesList.setEnabled(false);
            this.fFocusAreaText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fFocusAreaText.setEditable(false);
        } else {
            this.fIdText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fEmailText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fEmailText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fNumItemsText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fNumAnomaliesText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fNumCommentsText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDetailsText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            if (R4EUIModelController.getActiveReview() instanceof R4EUIReviewExtended) {
                R4EUIReviewExtended uiReview = (R4EUIReviewExtended)R4EUIModelController.getActiveReview();
                this.fTimeSection.setVisible(true);
                this.fRolesSection.setVisible(true);
                if (uiReview.isParticipantTimeSpentEnabled()) {
                    this.fTimeSpentDetailedList.setEnabled(true);
                } else {
                    this.fTimeSpentDetailedList.setEnabled(false);
                }
                if (uiReview.isParticipantExtraDetailsEnabled()) {
                    this.fRolesList.setEnabled(true);
                    this.fFocusAreaText.setForeground(UIUtils.ENABLED_FONT_COLOR);
                    this.fFocusAreaText.setEditable(true);
                } else {
                    this.fRolesList.setEnabled(false);
                    this.fFocusAreaText.setForeground(UIUtils.DISABLED_FONT_COLOR);
                    this.fFocusAreaText.setEditable(false);
                }
            } else {
                if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                    this.fTimeSection.setVisible(false);
                    this.fRolesSection.setVisible(false);
                } else {
                    this.fTimeSection.setVisible(true);
                    this.fRolesSection.setVisible(true);
                    this.fTimeSpentDetailedList.setEnabled(true);
                    this.fRolesList.setEnabled(true);
                }
                this.fFocusAreaText.setForeground(UIUtils.ENABLED_FONT_COLOR);
                this.fFocusAreaText.setEditable(true);
            }
        }
    }

    public void itemsUpdated(Item[] aItems, int aInstanceId) {
        try {
            R4EParticipant modelParticipant = ((R4EUIParticipant)this.fProperties.getElement()).getParticipant();
            String currentUser = R4EUIModelController.getReviewer();
            if (1 == aInstanceId) {
                EMap timeMap = modelParticipant.getTimeLog();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
                HashMap<Date, Integer> newAddTimes = new HashMap<Date, Integer>();
                HashMap<Date, Integer> newDeleteTimes = new HashMap<Date, Integer>();
                HashMap storedTimes = new HashMap();
                storedTimes.putAll(modelParticipant.getTimeLog().map());
                Item[] itemArray = aItems;
                int n = aItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    try {
                        newAddTimes.put(dateFormat.parse(((TableItem)item).getText(1)), Integer.valueOf(((TableItem)item).getText(0)));
                        newDeleteTimes.put(dateFormat.parse(((TableItem)item).getText(1)), Integer.valueOf(((TableItem)item).getText(0)));
                    }
                    catch (ParseException parseException) {}
                    ++n2;
                }
                Set storedKeys = storedTimes.keySet();
                for (Date storedKey : storedKeys) {
                    newAddTimes.remove(storedKey);
                }
                if (newAddTimes.size() > 0) {
                    Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, currentUser);
                    timeMap.putAll(newAddTimes);
                    R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                }
                Set deleteKeys = newDeleteTimes.keySet();
                for (Date deleteKey : deleteKeys) {
                    storedTimes.remove(deleteKey);
                }
                if (storedTimes.size() > 0) {
                    Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, currentUser);
                    for (Date storedKey : storedTimes.keySet()) {
                        timeMap.remove((Object)storedKey);
                    }
                    R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                }
            } else if (2 == aInstanceId) {
                Long bookNum;
                ArrayList<R4EUserRole> newAddUserRoles = new ArrayList<R4EUserRole>();
                ArrayList<R4EUserRole> newDeleteUserRoles = new ArrayList<R4EUserRole>();
                ArrayList storedUserRoles = new ArrayList();
                storedUserRoles.addAll(modelParticipant.getRoles());
                Item[] itemArray = aItems;
                int n = aItems.length;
                int n3 = 0;
                while (n3 < n) {
                    Item item = itemArray[n3];
                    R4EUserRole role = R4EUIParticipant.mapStringToRole(item.getText());
                    if (role != null) {
                        newAddUserRoles.add(role);
                        newDeleteUserRoles.add(role);
                    }
                    ++n3;
                }
                newAddUserRoles.removeAll(storedUserRoles);
                if (newAddUserRoles.size() > 0) {
                    bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, currentUser);
                    modelParticipant.getRoles().addAll(newAddUserRoles);
                    R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                }
                storedUserRoles.removeAll(newDeleteUserRoles);
                if (storedUserRoles.size() > 0) {
                    bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelParticipant, currentUser);
                    modelParticipant.getRoles().removeAll(storedUserRoles);
                    R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                }
                ((R4EUIParticipant)this.fProperties.getElement()).setRoleIcon(R4EUIModelController.getActiveReview().getReview().getType());
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
            this.refresh();
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
    }

    public void itemSelected(Item aItem, int aInstanceId) {
    }
}

