/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.report.internal.dialog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.SerializeFactory;
import org.eclipse.mylyn.reviews.r4e.internal.transform.ModelTransform;
import org.eclipse.mylyn.reviews.r4e.internal.transform.resources.ReviewGroupRes;
import org.eclipse.mylyn.reviews.r4e.report.impl.IR4EReport;
import org.eclipse.mylyn.reviews.r4e.report.internal.Activator;
import org.eclipse.mylyn.reviews.r4e.report.internal.dialog.ReportDirectorySelection;
import org.eclipse.mylyn.reviews.r4e.report.internal.util.OSPLATFORM;
import org.eclipse.mylyn.reviews.r4e.report.internal.util.Popup;
import org.eclipse.mylyn.reviews.r4e.report.internal.util.R4EReportString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.osgi.framework.Bundle;

public class ReportGeneration
implements IR4EReport {
    private Level fBIRT_LEVEL = Level.OFF;
    private String fLogConfigdir = "C:/R4EDebug";
    String fDesignName = "C:/git/r4eSecond/r4e/org.eclipse.mylyn.reviews.r4e.report/design/globalReport.rptdesign";
    public final String fFILE_SEPARATOR = "/";
    private final String fGROUP_DATA_SOURCE = "Merged_group";
    private final String fREVIEW_DATA_SOURCE = "Merged_review";
    private final String fInspectionRecordFileName = "inspectionRecord.rptdesign";
    private final String fGlobalReportFileName = "globalReport.rptdesign";
    private final String fR4E_GLOBAL_REPORT = "R4E_REPORT";
    private final String fINSPECT_RECORD = "InspectionRecord";
    private final String fNO_NAME = "NoNameYet";
    private final String fREVIEW_END = "_review";
    private final String fGROUP_END = "_group_root";
    private final String fEXTENSION = ".xrer";
    private final String fSOURCE_PREFIX = "Merged";
    private final String fPROJECT_REPORT_DIR = "Reports";
    private final String fPROJECT_WORKING_DIR = "r4e_work";
    private final String fGROUP_FILE = "Merged_group_root.xrer";
    private final String fFILE_SEP = "_";
    private final String fEXTENSION_SEPARATOR = ".";
    public final String fHTML_EXTENSION = "html";
    public final String fPDF_EXTENSION = "pdf";
    public final String fINSPECTION_RECORD_TYPE = "Inspection Record";
    public final String fGLOBAL_REPORT_TYPE = "Global Report";
    public final String fSINGLE_REPORT_TYPE = "List Single Report";
    private final int fGLOBAL_REPORT_NUM = 0;
    private final int fINSPECTION_RECORD_NUM = 1;
    private final int fSINGLE_REPORT_NUM = 2;
    private final SimpleDateFormat fDATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy_hhmmss", new Locale("eng", "US"));
    private final String fFOLDER = "src/org/eclipse/mylyn/reviews/r4e/report/internal/design";
    private String fR4E_REPORT = "R4E_REPORT";
    private InputStream fInputDesignName = null;
    private String fDesignFileName = "globalReport.rptdesign";
    private Boolean fPROPERTY_FILE_CREATED = false;
    private Composite fCompositeParent = null;
    private File fReportDir = null;
    private String fReportName = "";
    private int fCurrent_report_num = -1;
    private File[] fReviewNameList = null;
    private String fOutputFormat = "html";
    private R4EReviewGroup floadedGroup = null;
    private final Persistence.RModelFactoryExt fFactory = SerializeFactory.getModelExtension();
    private String fGroupFile = "";

    public void setReportType(String aReportType) {
        Activator.FTracer.traceInfo("ReportGeneration.setReportType() : " + aReportType);
        if (aReportType.equals("Global Report")) {
            this.fDesignFileName = "globalReport.rptdesign";
            this.setReportName("R4E_REPORT");
            this.fCurrent_report_num = 0;
        } else if (aReportType.equals("Inspection Record")) {
            this.fDesignFileName = "inspectionRecord.rptdesign";
            String inspectionReportName = this.buildInspectionReportName();
            this.setReportName(inspectionReportName);
            this.fCurrent_report_num = 1;
        } else {
            this.fDesignFileName = "globalReport.rptdesign";
            this.setReportName("R4E_REPORT");
            this.fCurrent_report_num = 2;
        }
        Activator.FTracer.traceInfo("ReportGeneration.setReportType() design file name: " + this.fDesignFileName + "\t\t cur number report: " + this.fCurrent_report_num);
    }

    public void setOuputFormat(String aFormatOutput) {
        Activator.FTracer.traceInfo("ReportGeneration.setOuputFormat() : " + aFormatOutput);
        this.fOutputFormat = aFormatOutput;
    }

    public void handleReportGeneration(String agroupFile, IProgressMonitor aMonitor) {
        this.setGroupFile(agroupFile);
        File groupFile = new File(agroupFile);
        File rootDir = groupFile.getParentFile();
        if (rootDir != null) {
            this.prepareReport(rootDir, aMonitor);
        }
    }

    public void setReviewListSelection(File[] aListSelectedReview) {
        this.fReviewNameList = aListSelectedReview;
    }

    public Boolean isInspectionRecord() {
        if (this.fCurrent_report_num == 1) {
            return true;
        }
        return false;
    }

    public int selectedReviewNumber() {
        File[] selectedReview = this.getReviewListSelection();
        int nbReview = selectedReview.length;
        return nbReview;
    }

    private void setReportName(String aStr) {
        this.fR4E_REPORT = aStr;
    }

    private EngineConfig createBirtDebug(EngineConfig aEngineConf) {
        if (OSPLATFORM.FTYPE.isWindowsOS() && this.fLogConfigdir != null) {
            File f = new File(this.fLogConfigdir);
            File newFile = this.createReportDir(f, "");
            Activator.FTracer.traceInfo("ReportGeneration.createBirtDebug() created:" + newFile.getAbsolutePath());
            if (!this.fBIRT_LEVEL.equals(Level.OFF)) {
                aEngineConf.setLogConfig(newFile.getAbsolutePath(), this.fBIRT_LEVEL);
            }
        }
        return aEngineConf;
    }

    private String buildInspectionReportName() {
        String inspectionFileName = "";
        StringBuilder sb = new StringBuilder();
        File[] reviewFile = this.getReviewListSelection();
        if (reviewFile != null) {
            if (reviewFile.length == 1) {
                sb.append("InspectionRecord");
                sb.append("_");
                sb.append(reviewFile[0].getName());
                inspectionFileName = sb.toString();
            }
        } else {
            sb.append("InspectionRecord");
            sb.append("_");
            sb.append("NoNameYet");
            inspectionFileName = sb.toString();
        }
        Activator.FTracer.traceInfo("buildInspectionReportName() :" + inspectionFileName);
        return inspectionFileName;
    }

    private File[] getReviewListSelection() {
        if (this.fReviewNameList != null) {
            int i = 0;
            while (i < this.fReviewNameList.length) {
                Activator.FTracer.traceInfo("getReviewListSelection() [" + i + " ] : " + this.fReviewNameList[i].getAbsolutePath());
                ++i;
            }
        } else {
            String message = R4EReportString.getString("Popup.noReview");
            Popup.warningRunnable(null, message);
        }
        return this.fReviewNameList;
    }

    private void setGroupFile(String aGroupFile) {
        this.fGroupFile = aGroupFile;
    }

    private String getGroupFile() {
        return this.fGroupFile;
    }

    private void setDesignReportTemplate() {
        Bundle bdl = Platform.getBundle((String)"org.eclipse.mylyn.reviews.r4e.report");
        StringBuilder rptDesign = new StringBuilder();
        rptDesign.append("src/org/eclipse/mylyn/reviews/r4e/report/internal/design");
        rptDesign.append("/");
        rptDesign.append(this.fDesignFileName);
        Path path = new Path(rptDesign.toString());
        try {
            this.fInputDesignName = FileLocator.openStream((Bundle)bdl, (IPath)path, (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            Activator.FTracer.traceInfo("ReportGeneration.setDesignReportTemplate() Input stream ioException: " + e);
        }
        if (this.fInputDesignName == null) {
            Activator.FTracer.traceInfo("ReportGeneration.setDesignReportTemplate() Did not find the design input stream");
            return;
        }
    }

    private InputStream getDesignReportTemplate() {
        return this.fInputDesignName;
    }

    private void cleanAndNotify(File aWorkDir, File aRootDir) {
        Activator.FTracer.traceInfo("ReportGeneration.cleanAndNotify() has no permission, no report created");
        this.cleanReportDirectory(aWorkDir);
        String reportParent = "";
        if (this.fReportDir != null) {
            reportParent = this.fReportDir.getAbsolutePath();
        } else if (aRootDir != null) {
            File fileReport = new File(String.valueOf(aRootDir.getParentFile().getAbsoluteFile().toString()) + "/" + "Reports");
            reportParent = fileReport.getAbsolutePath();
        }
        String message = R4EReportString.getFormattedString("Popup.accessDenied", reportParent);
        Popup.warningRunnable(null, message);
    }

    private void prepareReport(File aRootDir, IProgressMonitor aMonitor) {
        File workingDir = aRootDir;
        Activator.FTracer.traceInfo("ReportGeneration.prepareReport() Parent report Directory: " + workingDir);
        Date d = new Date();
        long ti = d.getTime();
        String stDate = StringConverter.asString((long)ti);
        StringBuilder workingStr = new StringBuilder();
        workingStr.append("r4e_work");
        workingStr.append("_");
        workingStr.append(stDate);
        workingDir = this.createReportDir(aRootDir, workingStr.toString());
        boolean ok = this.BuildReportDir(aRootDir);
        if (!ok) {
            this.cleanAndNotify(workingDir, aRootDir);
            return;
        }
        if (workingDir == null) {
            workingDir = this.createReportDir(this.fReportDir, workingStr.toString());
        }
        if (workingDir == null) {
            String message = R4EReportString.getString("Popup.noReportDir");
            Popup.error(null, message);
            return;
        }
        IReportRunnable runnable = null;
        EngineConfig config = new EngineConfig();
        config = this.createBirtDebug(config);
        ReportEngine engine = new ReportEngine(config);
        try {
            File[] selectedReview = this.getReviewListSelection();
            int nbReview = selectedReview.length;
            if (nbReview == 1) {
                aMonitor.subTask("Preparing Inspection Report...");
                this.setReportType("Inspection Record");
            } else {
                aMonitor.subTask("Preparing Global Report...");
                this.setReportType("Global Report");
            }
            this.setDesignReportTemplate();
            runnable = engine.openReportDesign(this.getDesignReportTemplate());
            ModuleHandle reportDesignHandle = runnable.getDesignHandle().getModuleHandle();
            this.prepareReportSourceFiles(workingDir, selectedReview);
            File[] destFile = workingDir.listFiles();
            int count = 0;
            while (count < destFile.length) {
                Activator.FTracer.traceInfo("List reportFile: " + destFile[count].getName());
                if (destFile[count].isFile()) {
                    aMonitor.subTask("Processing file " + destFile[count].getName());
                    this.prepareDataSource(destFile[count], reportDesignHandle, workingDir);
                }
                File[] revFile = destFile[count].listFiles();
                int i = 0;
                while (revFile != null && i < revFile.length) {
                    this.prepareDataSource(revFile[i], reportDesignHandle, workingDir);
                    ++i;
                }
                ++count;
            }
            aMonitor.subTask("Preparing Output File...");
            IRunAndRenderTask renderTask = this.prepareOutputFile(runnable, (IReportEngine)engine, this.fOutputFormat);
            renderTask.run();
        }
        catch (EngineException aEngineEx) {
            aEngineEx.printStackTrace();
            Activator.FTracer.traceInfo("ReportGeneration.prepareReport() Generate Report.run() EngineException : " + (Object)((Object)aEngineEx));
        }
        catch (ResourceHandlingException e) {
            e.printStackTrace();
            Activator.FTracer.traceInfo("ReportGeneration.prepareReport() ResourceHandlingException : " + (Object)((Object)e));
        }
        catch (CompatibilityException e) {
            e.printStackTrace();
            Activator.FTracer.traceInfo("ReportGeneration.prepareReport() CompatibilityException : " + (Object)((Object)e));
        }
        engine.destroy();
        this.cleanReportDirectory(workingDir);
        this.displayReport();
    }

    private ReviewGroupRes prepareReportSourceFiles(File aDestinationDir, File[] aSelectedReview) throws ResourceHandlingException, CompatibilityException {
        URI origURI = URI.createFileURI((String)this.getGroupFile());
        this.floadedGroup = this.fFactory.openR4EReviewGroup(origURI);
        int nbReview = aSelectedReview.length;
        URI destFolderURI = URI.createFileURI((String)aDestinationDir.getAbsolutePath());
        ReviewGroupRes destGroup = null;
        try {
            destGroup = ModelTransform.instance.createReviewGroupRes(destFolderURI, this.floadedGroup.getName(), "Merged");
        }
        catch (ResourceHandlingException e) {
            e.printStackTrace();
        }
        URI destURI = destGroup.eResource().getURI();
        int countReview = 0;
        while (countReview < nbReview) {
            String reviewName = aSelectedReview[countReview].getName();
            try {
                this.fFactory.openR4EReview(this.floadedGroup, reviewName);
                ModelTransform.instance.transformReview(origURI, destURI, reviewName);
            }
            catch (ResourceHandlingException e) {
                e.printStackTrace();
            }
            ++countReview;
        }
        return destGroup;
    }

    private void setPropertyFileCreated(Boolean aBol) {
        this.fPROPERTY_FILE_CREATED = aBol;
    }

    private void resetReportingFileCreated() {
        this.setPropertyFileCreated(false);
    }

    private IRunAndRenderTask prepareOutputFile(IReportRunnable aRunnable, IReportEngine aReportEngine, String aFormat) {
        RenderOption options = new RenderOption();
        options.setOutputFormat(aFormat);
        if (options.getOutputFormat().equalsIgnoreCase("html")) {
            HTMLRenderOption htmlOption = new HTMLRenderOption((IRenderOption)options);
            String output = this.createReportName("html");
            htmlOption.setOutputFileName(output);
            htmlOption.setOutputFormat("html");
        } else if (options.getOutputFormat().equalsIgnoreCase("pdf")) {
            PDFRenderOption pdfOptions = new PDFRenderOption((IRenderOption)options);
            pdfOptions.setOption("pdfRenderOption.pageOverflow", (Object)2);
            String output = this.createReportName("pdf");
            pdfOptions.setOutputFileName(output);
        }
        IRunAndRenderTask task = aReportEngine.createRunAndRenderTask(aRunnable);
        task.setRenderOption((IRenderOption)options);
        return task;
    }

    private void prepareDataSource(File aFile, ModuleHandle aReportDesignHandle, File aReportDir) {
        String[] sta = aFile.getName().split(".xrer");
        String name = sta[0];
        if (name.endsWith("_group_root")) {
            this.groupSetup(aFile, aReportDesignHandle);
        } else if (name.endsWith("_review")) {
            this.propertyReviewSetup(aFile, aReportDesignHandle, aReportDir);
        }
    }

    private String createReportName(String aExtension) {
        Date d = new Date();
        String user = this.getLocalUser();
        StringBuilder filename = new StringBuilder();
        filename.append(this.getReportDir().getAbsolutePath());
        filename.append("/");
        filename.append(this.fR4E_REPORT);
        filename.append("_");
        filename.append(user);
        filename.append("_");
        filename.append(this.fDATE_FORMAT.format(d));
        filename.append(".");
        filename.append(aExtension);
        Activator.FTracer.traceInfo("Report Name: " + filename.toString());
        this.fReportName = filename.toString();
        return this.fReportName;
    }

    private void propertyReviewSetup(File aFile, ModuleHandle aReportDesignHandle, File aReportDir) {
        this.setDataSourceFile(aFile, aReportDesignHandle, "Merged_review");
        this.setPropertyFileCreated(true);
    }

    private void groupSetup(File aFile, ModuleHandle aReportDesignHandle) {
        this.setDataSourceFile(aFile, aReportDesignHandle, "Merged_group");
    }

    private void setDataSourceFile(File aFile, ModuleHandle aReportDesignHandle, String data_source) {
        DataSourceHandle dso = aReportDesignHandle.findDataSource(data_source);
        if (dso == null) {
            Activator.FTracer.traceInfo("ReportGeneration.setDataSourceFile() DataSourceHandle is NULL");
        } else {
            Activator.FTracer.traceInfo("ReportGeneration.setDataSourceFile() DataSourceHandle : " + dso.getFullName() + "\n\t XPath: " + dso.getXPath() + "\n\t module: " + dso.getModule().getFileName() + "\n\t BeforeOpen: " + dso.getElement().toString() + "\n\t ElementFactory: " + dso.getElementFactory().toString());
            try {
                Activator.FTracer.traceInfo("ReportGeneration.setDataSourceFile() DSO before open OK ");
                dso.setProperty("FILELIST", (Object)aFile.getAbsolutePath());
            }
            catch (SemanticException e) {
                e.printStackTrace();
                Activator.FTracer.traceInfo("ReportGeneration.setDataSourceFile() DSO before open EXCEPTION: " + (Object)((Object)e));
            }
        }
    }

    private File createReportDir(File aReportDir, String aDirSt) {
        File parent = new File(String.valueOf(aReportDir.getAbsoluteFile().toString()) + "/" + aDirSt);
        if (!parent.exists() && !parent.mkdir()) {
            Activator.FTracer.traceInfo("ReportGeneration.createReportDir() ERROR");
            return null;
        }
        return parent;
    }

    private void cleanReportDirectory(File aReportDir) {
        if (aReportDir != null) {
            Activator.FTracer.traceInfo("ReportGeneration.cleanReportDirectory(): " + aReportDir.getAbsolutePath());
            if (aReportDir.exists()) {
                Boolean b;
                Activator.FTracer.traceInfo("ReportGeneration.cleanReportDirectory() Directory exists already.");
                File[] fileArray = aReportDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        File[] fileArray2 = f.listFiles();
                        int n3 = fileArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File sub = fileArray2[n4];
                            Boolean bl = sub.delete();
                            ++n4;
                        }
                    }
                    b = f.delete();
                    Activator.FTracer.traceInfo("ReportGeneration.cleanReportDirectory() Files to delete: " + f + "\t deleted: " + b);
                    ++n2;
                }
                b = aReportDir.delete();
                Activator.FTracer.traceInfo("ReportGeneration.cleanReportDirectory() removing Directory: " + aReportDir + "\t : " + b);
            } else {
                Activator.FTracer.traceInfo("ReportGeneration.cleanReportDirectory() Directory " + aReportDir.getAbsolutePath() + " DO not exist.");
            }
        }
        this.resetReportingFileCreated();
    }

    private boolean BuildReportDir(File aRootDir) {
        boolean ok = true;
        File parentDir = aRootDir.getParentFile();
        this.fReportDir = this.createReportDir(parentDir, "Reports");
        boolean b = this.verifyWritePermission(this.fReportDir);
        if (!b) {
            this.fReportDir = this.createSaveDirectory(this.fReportDir);
            boolean bo = this.verifyWritePermission(this.fReportDir);
            if (!bo) {
                ok = false;
            }
        }
        return ok;
    }

    private boolean verifyWritePermission(File aDir) {
        boolean b = true;
        if (aDir != null) {
            Activator.FTracer.traceInfo("ReportGeneration.verifyWritePermission() BEGIN:  " + aDir.getAbsolutePath());
            String test = "test.txt";
            StringBuilder sb = new StringBuilder();
            sb.append(aDir.toString());
            sb.append("/");
            sb.append(test);
            File f = new File(sb.toString());
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Activator.FTracer.traceInfo("Create a Report file is NOT allow: " + e.getMessage());
                b = false;
            }
            if (f.exists()) {
                Boolean del = f.delete();
                Activator.FTracer.traceInfo("Temp file " + f.getAbsolutePath() + " deleted: " + del);
            }
        } else {
            b = false;
        }
        return b;
    }

    private File createSaveDirectory(final File aReportDir) {
        final ReportDirectorySelection dirSelect = new ReportDirectorySelection(this.fCompositeParent.getShell());
        Runnable runnable = new Runnable(){

            public void run() {
                dirSelect.create();
                if (aReportDir != null) {
                    dirSelect.setFieldDirectory(aReportDir.getAbsolutePath());
                }
                dirSelect.open();
            }
        };
        Display.getDefault().syncExec(runnable);
        File fi = dirSelect.getReportDirectory();
        if (fi != null) {
            Activator.FTracer.traceInfo("File return from directory selection: " + fi.getAbsolutePath());
        } else {
            Activator.FTracer.traceInfo("File return from directory selection: NULL ");
        }
        return fi;
    }

    private File getReportDir() {
        return this.fReportDir;
    }

    private String getReportName() {
        return this.fReportName;
    }

    private void displayReport() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String[] buttonLabels = new String[]{"OK"};
                MessageDialog dialog = new MessageDialog(null, "Report Generated", null, "The following report has been generated: \n" + ReportGeneration.this.getReportName(), 2, buttonLabels, 0);
                dialog.open();
                ReportGeneration.this.openFile();
            }
        });
    }

    private void openFile() {
        block10: {
            String filename = this.getReportName();
            Activator.FTracer.traceInfo("ReportGeneration.openFile() " + filename);
            IWorkbench workbench = Activator.getDefault().getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(filename));
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            Activator.FTracer.traceInfo("ReportGeneration.openFile() " + fileStore.getName() + " Directory=" + fileStore.fetchInfo().isDirectory() + " Exist=" + fileStore.fetchInfo().exists());
            if (fileStore.fetchInfo().isDirectory()) {
                Activator.FTracer.traceInfo("ReportGeneration.openFile() File is a directory or does not exist. " + fileStore.getName());
            } else if (fileStore.fetchInfo().exists()) {
                Activator.FTracer.traceInfo("ReportGeneration.openFile() File ( " + fileStore.getName() + " ) exist, just handle it now");
            }
            if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                String editorId = this.getEditorId(fileStore);
                try {
                    IEditorPart fep = page.getActiveEditor();
                    FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                    if (fep != null) {
                        String strConvert = fep.getTitleToolTip().replace("\\", "/");
                        Activator.FTracer.traceInfo("ReportGeneration.openFile() find editorpart return: " + fep.toString() + "\n\t tooltip value: " + fep.getTitleToolTip() + "\n\t FileName: " + filename + "\n\t tooltip string converted: " + strConvert);
                        if (filename.equals(strConvert)) {
                            Activator.FTracer.traceInfo("ReportGeneration.OpenFile() current editor already display the file: " + fep.getTitleToolTip());
                        } else {
                            Activator.FTracer.traceInfo("ReportGeneration.openFile() need refresh to the right file: " + filename);
                            fep = page.openEditor((IEditorInput)input, editorId);
                        }
                        break block10;
                    }
                    Activator.FTracer.traceInfo("ReportGeneration.openFile() find editorpart return NULL");
                    fep = page.openEditor((IEditorInput)input, editorId);
                }
                catch (PartInitException e) {
                    String str = R4EReportString.getString("messageError1");
                    Activator.getDefault().logError(str, (Exception)((Object)e));
                    String msg = String.valueOf(str) + " : " + fileStore.getName();
                    MessageDialog.openError((Shell)window.getShell(), (String)str, (String)msg);
                }
            } else {
                Activator.FTracer.traceInfo("ReportGeneration.openFile() File is a directory or does not exist. " + fileStore.getName());
            }
        }
    }

    private String getEditorId(IFileStore aFileStore) {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(aFileStore.getName(), null);
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(aFileStore.getName())) {
            Activator.FTracer.traceInfo("ReportGeneration.getEditorId() SYSTEM_INPLACE_EDITOR_ID");
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(aFileStore.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            Activator.FTracer.traceInfo("ReportGeneration.getEditorId() editor id " + descriptor.getId() + " " + descriptor.getLabel());
            return descriptor.getId();
        }
        Activator.FTracer.traceInfo("ReportGeneration.getEditorId() DEFAULT_TEXT_EDITOR_ID");
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private void prepareMultiReport(File aRootDir) {
        File workingDir = null;
        File origWorkingDir = aRootDir.getParentFile();
        ReportEngine engine = null;
        Activator.FTracer.traceInfo("ReportGeneration.prepareMultiReport() Parent report Directory: " + workingDir);
        Boolean ok = this.BuildReportDir(aRootDir);
        if (!ok.booleanValue()) {
            this.cleanAndNotify(workingDir, aRootDir);
            return;
        }
        if (origWorkingDir == null) {
            String message = " Could not create the report directory";
            Popup.error(null, message);
            return;
        }
        IReportRunnable runnable = null;
        EngineConfig config = new EngineConfig();
        config = this.createBirtDebug(config);
        File[] selectedReview = this.getReviewListSelection();
        int nbReview = selectedReview.length;
        this.InitProgressBar(nbReview);
        engine = new ReportEngine(config);
        int countReview = 0;
        while (countReview < nbReview) {
            this.notifyProgress(countReview);
            Date d = new Date();
            long ti = d.getTime();
            String stDate = StringConverter.asString((long)ti);
            StringBuilder workingStr = new StringBuilder();
            workingStr.append("r4e_work");
            workingStr.append("_");
            workingStr.append(stDate);
            workingDir = this.createReportDir(origWorkingDir, workingStr.toString());
            this.setDesignReportTemplate();
            try {
                runnable = engine.openReportDesign(this.getDesignReportTemplate());
                Activator.FTracer.traceInfo("ReportGeneration.prepareReport()Engine getconfig: " + engine.getConfig() + "\n\t author:" + runnable.getProperty("author"));
                ModuleHandle reportDesignHandle = runnable.getDesignHandle().getModuleHandle();
                File[] selRev = new File[]{selectedReview[countReview]};
                this.prepareReportSourceFiles(workingDir, selRev);
                File[] destFile = workingDir.listFiles();
                int count = 0;
                while (count < destFile.length) {
                    Activator.FTracer.traceInfo("List reportFile: " + destFile[count].getName());
                    if (destFile[count].isFile()) {
                        this.prepareDataSource(destFile[count], reportDesignHandle, workingDir);
                    }
                    File[] revFile = destFile[count].listFiles();
                    int i = 0;
                    while (revFile != null && i < revFile.length) {
                        this.prepareDataSource(revFile[i], reportDesignHandle, workingDir);
                        ++i;
                    }
                    ++count;
                }
                IRunAndRenderTask renderTask = this.prepareOutputFile(runnable, (IReportEngine)engine, this.fOutputFormat);
                renderTask.run();
                this.cleanReportDirectory(workingDir);
            }
            catch (EngineException e) {
                String str = R4EReportString.getString("messageError2");
                Activator.getDefault().logError(str, (Exception)((Object)e));
                Activator.FTracer.traceInfo("ReportGeneration.prepareReport() Generate Report.run() EngineException : " + (Object)((Object)e));
            }
            catch (ResourceHandlingException e) {
                e.printStackTrace();
                Activator.FTracer.traceInfo("ReportGeneration.prepareReport() ResourceHandlingException : " + (Object)((Object)e));
            }
            catch (CompatibilityException e) {
                e.printStackTrace();
                Activator.FTracer.traceInfo("ReportGeneration.prepareReport() CompatibilityException : " + (Object)((Object)e));
            }
            ++countReview;
        }
        this.notifyProgressComplete();
        this.displayReport();
        engine.destroy();
    }

    private void InitProgressBar(int aNum) {
    }

    private void notifyProgressComplete() {
    }

    private void notifyProgress(int aCountReview) {
    }

    private String getLocalUser() {
        String localUser = new String(System.getProperty("user.name"));
        return localUser.toLowerCase();
    }

    public static void main(String[] args) {
        String[] strReviews = new String[]{"C:/temp/openTest/Formal-3"};
        File[] listSelectReviews = new File[strReviews.length];
        int i = 0;
        while (i < strReviews.length) {
            listSelectReviews[i] = new File(strReviews[i]);
            ++i;
        }
        String groupFile = "C:/temp/openTest/Various_group_root.xrer";
        ReportGeneration reportGen = new ReportGeneration();
        reportGen.setReviewListSelection(listSelectReviews);
        reportGen.setReportType(reportGen.fGLOBAL_REPORT_TYPE);
        reportGen.setOuputFormat(reportGen.fHTML_EXTENSION);
        reportGen.handleReportGeneration(groupFile, (IProgressMonitor)new NullProgressMonitor());
    }
}

