/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class R4EFileEditorInput
extends PlatformObject
implements IFileEditorInput {
    private final R4EFileVersion fFileVersion;

    public R4EFileEditorInput(R4EFileVersion aFileVersion) {
        Assert.isNotNull((Object)aFileVersion);
        this.fFileVersion = aFileVersion;
    }

    public IStorage getStorage() {
        return (IFile)this.fFileVersion.getResource();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.fFileVersion.getResource() != null) {
            return this.fFileVersion.getResource().getName();
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFileVersion.getResource().getFullPath().makeRelative().toString();
    }

    public Object getAdapter(Class aAdapter) {
        if (IFile.class.equals((Object)aAdapter) && this.fFileVersion.getResource() != null) {
            return this.fFileVersion.getResource();
        }
        if (IWorkbenchAdapter.class.equals((Object)aAdapter)) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    return new Object[0];
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return R4EFileEditorInput.this.getImageDescriptor();
                }

                public String getLabel(Object o) {
                    return R4EFileEditorInput.this.getName();
                }

                public Object getParent(Object o) {
                    return R4EFileEditorInput.this.getFile().getParent();
                }
            };
        }
        return super.getAdapter(aAdapter);
    }

    public boolean equals(Object aObject) {
        if (aObject == this) {
            return true;
        }
        if (aObject instanceof R4EFileEditorInput) {
            R4EFileEditorInput other = (R4EFileEditorInput)((Object)aObject);
            return other.fFileVersion.getResource().equals((Object)this.fFileVersion.getResource());
        }
        return false;
    }

    public int hashCode() {
        return this.fFileVersion.getResource().hashCode();
    }

    public R4EFileVersion getFileVersion() {
        return this.fFileVersion;
    }

    public IFile getFile() {
        return (IFile)this.fFileVersion.getResource();
    }
}

