/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.frame.core.model.Topic;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;
import org.eclipse.mylyn.reviews.notifications.spi.NotificationsConnector;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserReviews;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers.ImportPostponedHandler;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIParticipantContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ReviewProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIReviewBasic
extends R4EUIModelElement {
    public static final String REVIEW_BASIC_ICON_FILE = "icons/obj16/reviewbas_obj.gif";
    public static final String REVIEW_BASIC_CLOSED_ICON_FILE = "icons/obj16/revbasclsd_obj.gif";
    public static final String REVIEW_INFORMAL_ICON_FILE = "icons/obj16/reviewinf_obj.gif";
    public static final String REVIEW_INFORMAL_CLOSED_ICON_FILE = "icons/obj16/revinfclsd_obj.gif";
    private static final String OPEN_ELEMENT_COMMAND_NAME = "Open Review";
    private static final String OPEN_ELEMENT_COMMAND_TOOLTIP = "Open and Load Data for this Review";
    private static final String CLOSE_ELEMENT_COMMAND_NAME = "Close Review";
    private static final String CLOSE_ELEMENT_COMMAND_TOOLTIP = "Close and Unload Data for this Review";
    private static final String NEXT_STATE_ELEMENT_COMMAND_NAME = "Progress Review...";
    private static final String NEXT_STATE_ELEMENT_COMMAND_TOOLTIP = "Progress Review to Next Phase";
    private static final String PREVIOUS_STATE_ELEMENT_COMMAND_NAME = "Regress Review";
    private static final String PREVIOUS_STATE_ELEMENT_COMMAND_TOOLTIP = "Regress Review to Previous Phase";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Review";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Review from its Parent Review Group";
    private static final String REPORT_ELEMENT_COMMAND_TOOLTIP = "Generate a report for this Review";
    private static final String[] BASIC_PHASE_VALUES = new String[]{"STARTED", "COMPLETED"};
    private static final String EXIT_DECISION_NONE = "No Decision";
    private static final String EXIT_DECISION_ACCEPTED = "Accepted";
    private static final String EXIT_DECISION_ACCEPTED_FOLLOWUP = "Accepted with Follow-up";
    private static final String EXIT_DECISION_REJECTED = "Rejected";
    private static final String[] DECISION_VALUES = new String[]{"No Decision", "Accepted", "Accepted with Follow-up", "Rejected"};
    protected R4EReview fReview;
    protected final String fReviewName;
    protected final List<R4EUIReviewItem> fItems;
    protected R4EUIParticipantContainer fParticipantsContainer = null;
    protected R4EUIAnomalyContainer fAnomalyContainer = null;
    protected R4EUIPostponedContainer fPostponedContainer = null;

    public R4EUIReviewBasic(R4EUIReviewGroup aParent, R4EReview aReview, R4EReviewType aType, boolean aOpen) {
        super(aParent, R4EUIReviewBasic.getReviewDisplayName(aReview.getName(), aType));
        this.fReadOnly = false;
        this.fReview = aReview;
        this.fReviewName = aReview.getName();
        this.fParticipantsContainer = new R4EUIParticipantContainer(this, "Participants");
        this.fAnomalyContainer = new R4EUIAnomalyContainer(this, "Global Anomalies");
        this.fItems = new ArrayList<R4EUIReviewItem>();
        this.fOpen = aOpen;
        if (this.fOpen) {
            this.fParticipantsContainer.addChildren(new R4EUIParticipant(this.fParticipantsContainer, (R4EParticipant)this.fReview.getUsersMap().get((Object)R4EUIModelController.getReviewer()), aType));
            R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
            if (activeReview != null) {
                activeReview.close();
            }
            R4EUIModelController.setActiveReview(this);
        }
    }

    @Override
    public String getImageLocation() {
        if (this.isOpen()) {
            if (this.fReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                return REVIEW_BASIC_ICON_FILE;
            }
            return REVIEW_INFORMAL_ICON_FILE;
        }
        if (this.fReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
            return REVIEW_BASIC_CLOSED_ICON_FILE;
        }
        return REVIEW_INFORMAL_CLOSED_ICON_FILE;
    }

    @Override
    public String getToolTip() {
        return this.fReview.getExtraNotes();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ReviewProperties(this);
        }
        return null;
    }

    private static String getReviewDisplayName(String aName, R4EReviewType aType) {
        if (aType.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
            return "Informal: " + aName;
        }
        if (aType.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
            return "Basic: " + aName;
        }
        return aName;
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
        this.fReview.setExtraNotes(((R4EReview)aModelComponent).getExtraNotes());
        this.fReview.setType(((R4EReview)aModelComponent).getType());
        this.fReview.setProject(((R4EReview)aModelComponent).getProject());
        this.fReview.getComponents().addAll((Collection)((R4EReview)aModelComponent).getComponents());
        this.fReview.setEntryCriteria(((R4EReview)aModelComponent).getEntryCriteria());
        this.fReview.setObjectives(((R4EReview)aModelComponent).getObjectives());
        this.fReview.setReferenceMaterial(((R4EReview)aModelComponent).getReferenceMaterial());
        this.fReview.setDecision(((R4EReview)aModelComponent).getDecision());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public R4EReview getReview() {
        return this.fReview;
    }

    public R4EUIParticipantContainer getParticipantContainer() {
        return this.fParticipantsContainer;
    }

    public R4EUIAnomalyContainer getAnomalyContainer() {
        return this.fAnomalyContainer;
    }

    public R4EUIPostponedContainer getPostponedContainer() {
        return this.fPostponedContainer;
    }

    public R4EParticipant getParticipant(String aParticipant, boolean aCreate) throws ResourceHandlingException {
        R4EParticipant participant = null;
        if (this.isParticipant(aParticipant)) {
            participant = (R4EParticipant)this.fReview.getUsersMap().get((Object)aParticipant);
            if (aCreate && !participant.isEnabled()) {
                try {
                    R4EUIParticipant uiParticipant = this.fParticipantsContainer.getParticipant(participant);
                    if (uiParticipant == null) {
                        uiParticipant = new R4EUIParticipant(this.fParticipantsContainer, participant, this.fReview.getType());
                        this.fParticipantsContainer.addChildren(uiParticipant);
                    }
                    uiParticipant.setEnabled(true);
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                }
            }
        } else if (aCreate) {
            ArrayList<R4EUserRole> role = new ArrayList<R4EUserRole>(1);
            role.add(R4EUserRole.R4E_ROLE_REVIEWER);
            participant = R4EUIModelController.FModelExt.createR4EParticipant(this.fReview, aParticipant, role);
            this.fParticipantsContainer.addChildren(new R4EUIParticipant(this.fParticipantsContainer, participant, this.fReview.getType()));
        }
        return participant;
    }

    public boolean isParticipant(String aParticipant) {
        R4EUserReviews userReviews;
        return this.fReview != null && (this.isOpen() ? (R4EParticipant)this.fReview.getUsersMap().get((Object)aParticipant) != null : (userReviews = (R4EUserReviews)((R4EUIReviewGroup)this.getParent()).getReviewGroup().getUserReviews().get((Object)aParticipant)) != null && userReviews.getInvitedToMap().containsKey((Object)this.fReview.getName()));
    }

    public List<R4EParticipant> getParticipants() {
        Object[] users = this.fReview.getUsersMap().values().toArray();
        ArrayList<R4EParticipant> participants = new ArrayList<R4EParticipant>();
        Object[] objectArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            Object user = objectArray[n2];
            participants.add((R4EParticipant)user);
            ++n2;
        }
        return participants;
    }

    public List<String> getParticipantIDs() {
        Object[] users = this.fReview.getUsersMap().values().toArray();
        ArrayList<String> participantIDs = new ArrayList<String>();
        Object[] objectArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            Object user = objectArray[n2];
            if (((R4EParticipant)user).isEnabled()) {
                participantIDs.add(((R4EParticipant)user).getId());
            }
            ++n2;
        }
        return participantIDs;
    }

    public void verifyUserReviewed() {
        for (R4EUIReviewItem checkItem : this.fItems) {
            checkItem.verifyUserReviewed();
        }
        boolean allChildrenReviewed = true;
        int length = this.fItems.size();
        int i = 0;
        while (i < length) {
            if (!this.fItems.get(i).isUserReviewed()) {
                allChildrenReviewed = false;
            }
            ++i;
        }
        this.fUserReviewed = allChildrenReviewed;
        try {
            R4EParticipant participant = this.getParticipant(R4EUIModelController.getReviewer(), false);
            if (participant != null && participant.isReviewCompleted() != this.fUserReviewed) {
                this.setUserReviewed(this.fUserReviewed, false, true);
            }
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
    }

    @Override
    public boolean isUserReviewed() {
        try {
            R4EParticipant participant = this.getParticipant(R4EUIModelController.getReviewer(), false);
            if (participant != null) {
                return participant.isReviewCompleted();
            }
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
            return this.fUserReviewed;
        }
        return this.fUserReviewed;
    }

    @Override
    public void setUserReviewed(boolean aReviewed, boolean aSetChildren, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        R4EParticipant participant;
        if (aUpdateModel && (participant = this.getParticipant(R4EUIModelController.getReviewer(), false)) != null) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
            participant.setReviewCompleted(aReviewed);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        this.fUserReviewed = aReviewed;
        if (aSetChildren) {
            int length = this.fItems.size();
            int i = 0;
            while (i < length) {
                this.fItems.get(i).setUserReviewed(aReviewed, aSetChildren, aUpdateModel);
                ++i;
            }
        }
    }

    @Override
    public void checkToSetUserReviewed(boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        boolean allChildrenReviewed = true;
        int length = this.fItems.size();
        int i = 0;
        while (i < length) {
            if (!this.fItems.get(i).isUserReviewed()) {
                allChildrenReviewed = false;
            }
            ++i;
        }
        if (allChildrenReviewed) {
            R4EParticipant participant;
            if (aUpdateModel && (participant = this.getParticipant(R4EUIModelController.getReviewer(), true)) != null) {
                Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
                participant.setReviewCompleted(true);
                R4EUIModelController.FResourceUpdater.checkIn(bookNum);
            }
            this.fUserReviewed = true;
        }
    }

    @Override
    public void close() {
        R4EUIReviewItem reviewItem = null;
        int itemsSize = this.fItems.size();
        int i = 0;
        while (i < itemsSize) {
            reviewItem = this.fItems.get(i);
            reviewItem.close();
            ++i;
        }
        this.fParticipantsContainer.close();
        this.fAnomalyContainer.close();
        if (this.fPostponedContainer != null) {
            this.fPostponedContainer.close();
        }
        this.fItems.clear();
        this.fOpen = false;
        this.fReadOnly = false;
        R4EUIModelController.FModelExt.closeR4EReview(this.fReview);
        R4EUIModelController.clearAnomalyMap();
        this.fImage = this.fReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC) ? UIUtils.loadIcon(REVIEW_BASIC_CLOSED_ICON_FILE) : UIUtils.loadIcon(REVIEW_INFORMAL_CLOSED_ICON_FILE);
        R4EUIModelController.setActiveReview(null);
    }

    @Override
    public void open() throws ResourceHandlingException, FileNotFoundException, CompatibilityException {
        this.fReview = R4EUIModelController.FModelExt.openR4EReview(((R4EUIReviewGroup)this.getParent()).getReviewGroup(), this.fReviewName);
        if (this.checkCompatibility()) {
            EList items = this.fReview.getReviewItems();
            if (items != null) {
                R4EUIFileContainer uiItem = null;
                ArrayList<IR4EUIModelElement> uiItemList = new ArrayList<IR4EUIModelElement>();
                R4EUIModelController.mapAnomalies(this.fReview);
                int itemsSize = items.size();
                R4EItem item = null;
                int i = 0;
                while (i < itemsSize) {
                    item = (R4EItem)items.get(i);
                    if (item.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                        if ("true".equals(item.getInfoAtt().get((Object)"isPostponed"))) {
                            uiItem = new R4EUIPostponedContainer(this, item, "Imported Anomalies");
                        } else if (item.getRepositoryRef() == null || "".equals(item.getRepositoryRef())) {
                            EList contextList = item.getFileContextList();
                            StringBuilder name = new StringBuilder("Resource: ");
                            if (contextList.size() > 0) {
                                name = name.append(((R4EFileContext)item.getFileContextList().get(0)).getTarget().getName());
                            } else {
                                R4EUIPlugin.Ftracer.traceError("Context list empty in a review item, index: " + i);
                            }
                            uiItem = new R4EUIReviewItem(this, item, name.toString(), 0);
                        } else {
                            String description = item.getDescription();
                            int endIndex = description.length() > 10 ? 10 : description.length();
                            String name = "Commit: " + description.substring(0, endIndex) + "...";
                            uiItem = new R4EUIReviewItem(this, item, name, 1);
                        }
                        uiItemList.add(uiItem);
                        this.addChildren(uiItem);
                    }
                    ++i;
                }
                this.getAnomalies(uiItemList);
                this.verifyUserReviewed();
            }
            this.fAnomalyContainer.setReadOnly(this.fReadOnly);
            this.fAnomalyContainer.open();
            this.fParticipantsContainer.setReadOnly(this.fReadOnly);
            this.fParticipantsContainer.open();
            try {
                CommandUtils.showPostponedElements(this);
            }
            catch (OutOfSyncException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
            }
            this.fOpen = true;
            if (this.fReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                this.fImage = UIUtils.loadIcon(REVIEW_BASIC_ICON_FILE);
            } else if (this.fReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                this.fImage = UIUtils.loadIcon(REVIEW_INFORMAL_ICON_FILE);
            }
            R4EUIModelController.setActiveReview(this);
            ImportPostponedHandler.refreshPostponedElements((IProgressMonitor)new NullProgressMonitor());
        } else {
            R4EUIModelController.FModelExt.closeR4EReview(this.fReview);
        }
    }

    private void getAnomalies(List<IR4EUIModelElement> aItemList) throws ResourceHandlingException, FileNotFoundException, CompatibilityException {
        if (aItemList != null) {
            int itemsSize = aItemList.size();
            int i = 0;
            while (i < itemsSize) {
                if (aItemList.get(i).isEnabled()) {
                    aItemList.get(i).open();
                }
                ++i;
            }
        }
    }

    private boolean checkCompatibility() {
        int checkResult = this.fReview.getCompatibility();
        switch (checkResult) {
            case -1: {
                UIUtils.displayCompatibilityErrorDialog();
                return false;
            }
            case 1: {
                int result = UIUtils.displayCompatibilityWarningDialog(this.fReview.getFragmentVersion(), this.fReview.getApplicationVersion());
                switch (result) {
                    case 0: {
                        try {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
                            this.fReview.setFragmentVersion(this.fReview.getApplicationVersion());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                            return false;
                        }
                        catch (OutOfSyncException e) {
                            UIUtils.displaySyncErrorDialog(e);
                            return false;
                        }
                        this.fReadOnly = false;
                        return true;
                    }
                    case 1: {
                        this.fReadOnly = true;
                        return true;
                    }
                }
                return false;
            }
        }
        this.fReadOnly = false;
        return true;
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        this.fReview = R4EUIModelController.FModelExt.openR4EReview(((R4EUIReviewGroup)this.getParent()).getReviewGroup(), this.fReviewName);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
        this.fReview.setEnabled(aEnabled);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIModelController.FModelExt.closeR4EReview(this.fReview);
    }

    @Override
    public boolean isEnabled() {
        return this.fReview.isEnabled();
    }

    public void setMeetingData(IMeetingData aMeetingData) throws ResourceHandlingException, OutOfSyncException {
        if (aMeetingData != null) {
            R4EMeetingData coreMeetingData = this.fReview.getActiveMeeting();
            if (coreMeetingData == null) {
                coreMeetingData = R4EUIModelController.FModelExt.createR4EMeetingData(this.fReview);
            }
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
            coreMeetingData.setId(aMeetingData.getCustomID());
            coreMeetingData.setSender(aMeetingData.getSender());
            String[] stringArray = aMeetingData.getReceivers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String receiver = stringArray[n2];
                coreMeetingData.getReceivers().add((Object)receiver);
                ++n2;
            }
            coreMeetingData.setBody(aMeetingData.getBody());
            coreMeetingData.setSubject(aMeetingData.getSubject());
            coreMeetingData.setLocation(aMeetingData.getLocation());
            coreMeetingData.setStartTime(aMeetingData.getStartTime().longValue());
            coreMeetingData.setDuration(aMeetingData.getDuration().intValue());
            coreMeetingData.setSentCount(coreMeetingData.getSentCount() + 1);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
    }

    public void refreshMeetingData() throws ResourceHandlingException, OutOfSyncException {
        NotificationsConnector mailConnector = R4EUIDialogFactory.getInstance().getMailConnector();
        final R4EMeetingData coreMeetingData = this.fReview.getActiveMeeting();
        final Persistence.ResourceUpdater resUpdater = R4EUIModelController.FResourceUpdater;
        if (coreMeetingData == null) {
            return;
        }
        IMeetingData meetingData = new IMeetingData(){

            public int getSentCounter() {
                return coreMeetingData.getSentCount();
            }

            public void incrementSentCounter() {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setSentCount(coreMeetingData.getSentCount() + 1);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public void clearSentCounter() {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setSentCount(0);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getCustomID() {
                return coreMeetingData.getId();
            }

            public void setCustomID(String aId) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setId(aId);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getSubject() {
                return coreMeetingData.getSubject();
            }

            public void setSubject(String aSubject) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setSubject(aSubject);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getBody() {
                return coreMeetingData.getBody();
            }

            public void setBody(String aBody) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setBody(aBody);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getLocation() {
                return coreMeetingData.getLocation();
            }

            public void setLocation(String aLocation) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setLocation(aLocation);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public Long getStartTime() {
                return coreMeetingData.getStartTime();
            }

            public void setStartTime(Long aStartTime) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setStartTime(aStartTime.longValue());
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public Integer getDuration() {
                return coreMeetingData.getDuration();
            }

            public void setDuration(Integer aDuration) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setDuration(aDuration.intValue());
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getSender() {
                return coreMeetingData.getSender();
            }

            public void setSender(String aSender) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.setSender(aSender);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String[] getReceivers() {
                EList recieversL = coreMeetingData.getReceivers();
                String[] receivers = (String[])recieversL.toArray((Object[])new String[recieversL.size()]);
                return receivers;
            }

            public void clearReceivers() {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.getReceivers().clear();
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public void addReceiver(String aReceiver) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.getReceivers().add((Object)aReceiver);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public void removeReceiver(String aReceiver) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)coreMeetingData, R4EUIModelController.getReviewer());
                    coreMeetingData.getReceivers().remove((Object)aReceiver);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
        };
        if (mailConnector != null && (meetingData = mailConnector.fetchSystemMeetingData(meetingData, this.fReview.getStartDate())) != null) {
            this.setMeetingData(meetingData);
        }
    }

    @Override
    public boolean hasChildren() {
        return this.isOpen() && (this.fItems.size() > 0 || this.fAnomalyContainer != null || this.fParticipantsContainer != null || this.fPostponedContainer != null);
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        ArrayList<R4EUIModelElement> newList = new ArrayList<R4EUIModelElement>();
        if (this.isOpen()) {
            newList.addAll(this.fItems);
            newList.add(this.fAnomalyContainer);
            if (this.fPostponedContainer != null && this.fPostponedContainer.getChildren().length > 0) {
                newList.add(this.fPostponedContainer);
            }
            newList.add(this.fParticipantsContainer);
        }
        return newList.toArray(new IR4EUIModelElement[newList.size()]);
    }

    public List<R4EUIReviewItem> getReviewItems() {
        IR4EUIModelElement[] reviewChildren = this.getChildren();
        ArrayList<R4EUIReviewItem> reviewItems = new ArrayList<R4EUIReviewItem>();
        IR4EUIModelElement[] iR4EUIModelElementArray = reviewChildren;
        int n = reviewChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement child = iR4EUIModelElementArray[n2];
            if (child instanceof R4EUIReviewItem) {
                reviewItems.add((R4EUIReviewItem)child);
            }
            ++n2;
        }
        return reviewItems;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        if (aChildToAdd instanceof R4EUIPostponedContainer) {
            this.fPostponedContainer = (R4EUIPostponedContainer)aChildToAdd;
        } else if (aChildToAdd instanceof R4EUIReviewItem) {
            this.fItems.add((R4EUIReviewItem)aChildToAdd);
        } else if (aChildToAdd instanceof R4EUIAnomalyContainer) {
            this.fAnomalyContainer = (R4EUIAnomalyContainer)aChildToAdd;
        } else if (aChildToAdd instanceof R4EUIParticipantContainer) {
            this.fParticipantsContainer = (R4EUIParticipantContainer)aChildToAdd;
        }
    }

    public R4EUIReviewItem createResourceReviewItem(String aFilename) throws ResourceHandlingException, OutOfSyncException {
        R4EParticipant participant = this.getParticipant(R4EUIModelController.getReviewer(), true);
        R4EItem reviewItem = R4EUIModelController.FModelExt.createR4EItem(participant);
        String name = "Resource: " + aFilename;
        R4EUIReviewItem uiReviewItem = new R4EUIReviewItem(this, reviewItem, name, 0);
        this.addChildren(uiReviewItem);
        this.setUserReviewed(false, false, true);
        return uiReviewItem;
    }

    public R4EUIReviewItem createCommitReviewItem(ChangeSet aChangeSet, String aFilename) throws ResourceHandlingException, OutOfSyncException {
        R4EParticipant participant = this.getParticipant(R4EUIModelController.getReviewer(), true);
        R4EItem reviewItem = R4EUIModelController.FModelExt.createR4EItem(participant);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)reviewItem, R4EUIModelController.getReviewer());
        reviewItem.setDescription(aChangeSet.getMessage());
        reviewItem.setAuthorRep(aChangeSet.getAuthor().getId());
        reviewItem.setRepositoryRef(aChangeSet.getId());
        reviewItem.setSubmitted(aChangeSet.getDate());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        String message = aChangeSet.getMessage();
        int endIndex = message.length() > 10 ? 10 : message.length();
        String name = "Commit: " + message.substring(0, endIndex) + "...";
        R4EUIReviewItem uiReviewItem = new R4EUIReviewItem(this, reviewItem, name, 1);
        this.addChildren(uiReviewItem);
        this.setUserReviewed(false, false, true);
        return uiReviewItem;
    }

    public R4EUIPostponedContainer createPostponedContainer() throws ResourceHandlingException, OutOfSyncException {
        R4EParticipant participant = this.getParticipant(R4EUIModelController.getReviewer(), true);
        R4EItem reviewItem = R4EUIModelController.FModelExt.createR4EItem(participant);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)reviewItem, R4EUIModelController.getReviewer());
        EMap info = reviewItem.getInfoAtt();
        info.put((Object)"isPostponed", (Object)"true");
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        this.fPostponedContainer = new R4EUIPostponedContainer(this, reviewItem, "Imported Anomalies");
        this.addChildren(this.fPostponedContainer);
        return this.fPostponedContainer;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        if (aChildToRemove instanceof R4EUIReviewItem) {
            R4EUIFileContainer removedElement = (R4EUIFileContainer)aChildToRemove;
            removedElement.removeAllChildren(aFileRemove);
            R4EItem modelItem = removedElement.getItem();
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelItem, R4EUIModelController.getReviewer());
            modelItem.setEnabled(false);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fItems.remove(removedElement);
            }
        } else if (aChildToRemove instanceof R4EUIPostponedContainer) {
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fPostponedContainer.removeAllChildren(aFileRemove);
                this.fPostponedContainer = null;
            }
        } else if (aChildToRemove instanceof R4EUIAnomalyContainer) {
            this.fAnomalyContainer.removeAllChildren(aFileRemove);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fAnomalyContainer = null;
            }
        } else if (aChildToRemove instanceof R4EUIParticipantContainer) {
            this.fParticipantsContainer.removeAllChildren(aFileRemove);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fParticipantsContainer = null;
            }
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIReviewItem item : this.fItems) {
            this.removeChildren(item, aFileRemove);
        }
    }

    @Override
    public boolean isChangeUserReviewStateCmd() {
        return this.isEnabled() && this.isOpen() && !this.isReadOnly() && !((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isOpenElementCmd() {
        return this.isEnabled() && !this.isOpen();
    }

    @Override
    public String getOpenElementCmdName() {
        return OPEN_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getOpenElementCmdTooltip() {
        return OPEN_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isReportElementCmd() {
        if (this.isEnabled()) {
            return R4EUIPlugin.isUserReportAvailable();
        }
        return false;
    }

    @Override
    public String getReportElementCmdName() {
        return "Generate Report";
    }

    @Override
    public String getReportElementCmdTooltip() {
        return REPORT_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isCloseElementCmd() {
        return this.isOpen();
    }

    @Override
    public String getCloseElementCmdName() {
        return CLOSE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public boolean isNextStateElementCmd() {
        return this.isOpen() && !this.isReadOnly();
    }

    @Override
    public String getNextStateElementCmdName() {
        return NEXT_STATE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNextStateElementCmdTooltip() {
        return NEXT_STATE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isPreviousStateElementCmd() {
        return this.isOpen() && !this.isReadOnly();
    }

    @Override
    public String getPreviousStateElementCmdName() {
        return PREVIOUS_STATE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getPreviousStateElementCmdTooltip() {
        return PREVIOUS_STATE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public String getCloseElementCmdTooltip() {
        return CLOSE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return !this.isOpen() && this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public boolean isAssigned(String aUsername, boolean aCheckChildren) {
        if (aCheckChildren) {
            for (R4EUIReviewItem item : this.fItems) {
                if (!item.isAssigned(aUsername, aCheckChildren)) continue;
                return true;
            }
            EList anomalies = this.fReview.getTopics();
            for (Topic anomaly : anomalies) {
                if (!anomaly.isEnabled() || !((R4EAnomaly)anomaly).getAssignedTo().contains((Object)aUsername)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRestoreElementCmd() {
        if (!this.getParent().isEnabled()) {
            return false;
        }
        return !this.isOpen() && !this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isSendEmailCmd() {
        return this.isOpen();
    }

    @Override
    public boolean isImportPostponedCmd() {
        return !this.getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC) && this.isOpen() && !this.isReadOnly() && !((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    public void setDate(R4EReviewPhase aNewPhase) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
        Date date = Calendar.getInstance().getTime();
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) {
            ((R4EFormalReview)this.fReview).getCurrent().setStartDate(date);
        } else if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) {
            ((R4EFormalReview)this.fReview).getCurrent().setStartDate(date);
        } else if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
            ((R4EFormalReview)this.fReview).getCurrent().setStartDate(date);
        } else if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            this.fReview.setEndDate(date);
        } else {
            this.fReview.setEndDate(null);
        }
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public void updatePhase(R4EReviewPhase aNewPhase) throws ResourceHandlingException, OutOfSyncException {
        if (!((R4EReviewState)this.fReview.getState()).getState().equals((Object)aNewPhase)) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
            ((R4EReviewState)this.fReview.getState()).setState(aNewPhase);
            if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
                R4EUIModelController.getActiveReview().getReview().setEndDate(Calendar.getInstance().getTime());
            } else {
                R4EUIModelController.getActiveReview().getReview().setEndDate(null);
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
    }

    public String getPhaseString(R4EReviewPhase aNewPhase) {
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_STARTED)) {
            return "STARTED";
        }
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            return "COMPLETED";
        }
        return "";
    }

    public R4EReviewPhase getPhaseFromString(String aNewPhase) {
        if (aNewPhase.equals("STARTED")) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_STARTED;
        }
        if (aNewPhase.equals("COMPLETED")) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED;
        }
        return null;
    }

    public String[] getPhases() {
        return BASIC_PHASE_VALUES;
    }

    public String[] getAvailablePhases() {
        R4EReviewPhase[] phases = this.getAllowedPhases(((R4EReviewState)this.getReview().getState()).getState());
        ArrayList<String> phaseStrings = new ArrayList<String>();
        R4EReviewPhase[] r4EReviewPhaseArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            R4EReviewPhase phase = r4EReviewPhaseArray[n2];
            phaseStrings.add(this.getPhaseString(phase));
            ++n2;
        }
        return phaseStrings.toArray(new String[phaseStrings.size()]);
    }

    public int mapPhaseToIndex(R4EReviewPhase aPhase) {
        R4EReviewPhase[] phases = this.getAllowedPhases(((R4EReviewState)this.getReview().getState()).getState());
        int i = 0;
        while (i < phases.length) {
            if (phases[i].getValue() == aPhase.getValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected R4EReviewPhase[] getAllowedPhases(R4EReviewPhase aCurrentPhase) {
        ArrayList<R4EReviewPhase> phases = new ArrayList<R4EReviewPhase>();
        switch (aCurrentPhase.getValue()) {
            case 0: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
                break;
            }
            case 4: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
            }
        }
        return phases.toArray(new R4EReviewPhase[phases.size()]);
    }

    public boolean validatePhaseChange(R4EReviewPhase aNextPhase, AtomicReference<String> aErrorMessage) {
        switch (aNextPhase.getValue()) {
            case 4: {
                if (this.checkCompletionStatus(aErrorMessage)) break;
                return false;
            }
        }
        return true;
    }

    public boolean checkCompletionStatus(AtomicReference<String> aErrorMessage) {
        if (!this.fReview.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
            if (this.fReview.getDecision() == null || this.fReview.getDecision().getValue() == null) {
                aErrorMessage.set("Phase cannot be changed to COMPLETED as review exit decision information is missing");
                return false;
            }
            if (this.fReview.getDecision().getValue().equals((Object)R4EDecision.R4E_REVIEW_DECISION_NONE)) {
                aErrorMessage.set("Phase cannot be changed to COMPLETED as review exit decision information is set to NONE");
                return false;
            }
            if (this.fReview.getDecision().getValue().equals((Object)R4EDecision.R4E_REVIEW_DECISION_REJECTED)) {
                aErrorMessage.set("Phase cannot be changed to COMPLETED as review exit decision information is set to REJECTED");
                return true;
            }
            AtomicReference<Object> resultMsg = new AtomicReference<Object>(null);
            StringBuilder sb = new StringBuilder();
            boolean resultOk = true;
            if (!this.fAnomalyContainer.checkCompletionStatus(resultMsg)) {
                sb.append("Phase cannot be changed to COMPLETED as some anomalies are in the wrong state:" + R4EUIConstants.LINE_FEED);
                sb.append(resultMsg);
                resultOk = false;
            }
            for (R4EUIReviewItem item : this.fItems) {
                R4EUIFileContext[] contexts;
                R4EUIFileContext[] r4EUIFileContextArray = contexts = (R4EUIFileContext[])item.getChildren();
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    R4EUIFileContext context = r4EUIFileContextArray[n2];
                    R4EUIAnomalyContainer container = context.getAnomalyContainerElement();
                    if (!container.checkCompletionStatus(resultMsg)) {
                        if (resultOk) {
                            sb.append("Phase cannot be changed to COMPLETED as some anomalies are in the wrong state:" + R4EUIConstants.LINE_FEED);
                            resultOk = false;
                        }
                        if (resultMsg != null) {
                            sb.append(resultMsg);
                        }
                    }
                    ++n2;
                }
            }
            if (!resultOk) {
                aErrorMessage.set(sb.toString());
                return false;
            }
        }
        return true;
    }

    public boolean isExitDecisionEnabled() {
        return !((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    public static String[] getExitDecisionValues() {
        return DECISION_VALUES;
    }

    public static R4EReviewDecision getDecisionValueFromString(String aDecision) {
        R4EReviewDecision reviewDecision = Persistence.RModelFactoryExt.eINSTANCE.createR4EReviewDecision();
        if (aDecision.equals(EXIT_DECISION_ACCEPTED)) {
            reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_ACCEPTED);
        } else if (aDecision.equals(EXIT_DECISION_ACCEPTED_FOLLOWUP)) {
            reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP);
        } else if (aDecision.equals(EXIT_DECISION_REJECTED)) {
            reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_REJECTED);
        } else {
            reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_NONE);
        }
        return reviewDecision;
    }

    public List<R4EUIReviewItem> getItems() {
        return this.fItems;
    }
}

