/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.RuleProperties;
import org.eclipse.ui.views.properties.IPropertySource;

public class R4EUIRule
extends R4EUIModelElement {
    public static final String RULE_ICON_FILE = "icons/obj16/rule_obj.gif";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Rule";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Rule from its parent Rule Violation";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Rule";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Rule";
    private final R4EDesignRule fRule;

    public R4EUIRule(IR4EUIModelElement aParent, R4EDesignRule aRule) {
        super(aParent, aRule.getId());
        this.fReadOnly = aParent.isReadOnly();
        this.fRule = aRule;
    }

    public String getImageLocation() {
        return RULE_ICON_FILE;
    }

    public String getToolTip() {
        return this.fRule.getTitle();
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new RuleProperties(this);
        }
        return null;
    }

    public R4EDesignRule getRule() {
        return this.fRule;
    }

    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fRule, R4EUIModelController.getReviewer());
        this.fRule.setId(((R4EDesignRule)aModelComponent).getId());
        this.fRule.setTitle(((R4EDesignRule)aModelComponent).getTitle());
        this.fRule.setDescription(((R4EDesignRule)aModelComponent).getDescription());
        this.fRule.setClass(((R4EDesignRule)aModelComponent).getClass_());
        this.fRule.setRank(((R4EDesignRule)aModelComponent).getRank());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fRule, R4EUIModelController.getReviewer());
        this.fRule.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public boolean isEnabled() {
        return this.fRule.isEnabled();
    }

    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly();
    }

    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    public boolean isRestoreElementCmd() {
        return !this.isEnabled() && !this.isReadOnly();
    }

    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }
}

