/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.utils;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.reviews.r4e.core.Activator;

public class ResourceUtils {
    public static IFile toIFile(String platformUriStr) throws FileNotFoundException {
        if (platformUriStr == null) {
            return null;
        }
        URI platformUri = URI.createURI((String)platformUriStr);
        return ResourceUtils.toIFile(platformUri);
    }

    public static IProject toIProject(String platformUriStr) throws FileNotFoundException {
        if (platformUriStr == null) {
            return null;
        }
        URI platformUri = URI.createURI((String)platformUriStr);
        return ResourceUtils.toIProject(platformUri);
    }

    public static IFile toIFile(URI platformUri) throws FileNotFoundException {
        if (platformUri == null) {
            return null;
        }
        if (!platformUri.isPlatform()) {
            throw new IllegalArgumentException("Not a platform uri");
        }
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformUri.toPlatformString(true)));
        if (!ifile.exists()) {
            StringBuilder sb = new StringBuilder("The file: " + platformUri.toString() + " does not exists in the workspace");
            Activator.fTracer.traceWarning(sb.toString());
            throw new FileNotFoundException(sb.toString());
        }
        return ifile;
    }

    public static IProject toIProject(URI platformUri) throws FileNotFoundException {
        if (platformUri == null) {
            return null;
        }
        if (!platformUri.isPlatform()) {
            throw new IllegalArgumentException("Not a platform uri");
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(platformUri.toPlatformString(true));
        if (iProject == null) {
            StringBuilder sb = new StringBuilder("The Project: " + platformUri.toString() + " does not exists in the workspace");
            Activator.fTracer.traceWarning(sb.toString());
            throw new FileNotFoundException(sb.toString());
        }
        return iProject;
    }

    public static URI toPlatformURI(IFile ifile) {
        if (ifile == null) {
            throw new IllegalArgumentException("input is null");
        }
        URI genURI = URI.createPlatformResourceURI((String)ifile.getFullPath().toString(), (boolean)true);
        return genURI;
    }

    public static String toPlatformURIStr(IResource aResource) {
        if (aResource == null) {
            return null;
        }
        URI resUri = URI.createPlatformResourceURI((String)aResource.getFullPath().toString(), (boolean)true);
        return resUri.toString();
    }

    public static IResource findResource(IProject project, String relativeProjectPath) {
        if (project == null || relativeProjectPath == null) {
            return null;
        }
        return project.findMember(relativeProjectPath);
    }

    public static IProject[] getProjects() {
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] projects = root.getRoot().getProjects();
        return projects;
    }

    public static IProject getProject(String name) {
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] projects = root.getRoot().getProjects();
        IProject project = null;
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project2 = iProjectArray[n2];
                project = project2;
                if (project.getName().equals(name)) {
                    return project;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IFile getWorkSpaceFile(java.net.URI aFilePathURI, IProject aProject) {
        IFile[] files;
        IFile[] iFileArray = files = ResourceUtils.getWorkSpaceFiles(aFilePathURI);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile = iFileArray[n2];
            if (iFile.getProject().equals((Object)aProject)) {
                return iFile;
            }
            ++n2;
        }
        return null;
    }

    private static IFile[] getWorkSpaceFiles(java.net.URI filePathURI) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = null;
        if (filePathURI != null) {
            files = ResourceUtils.filterNonExistentFiles(root.findFilesForLocationURI(filePathURI));
        }
        return files;
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            } else if (files[i].getType() == 1) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    public static URI getFolderPath(URI uri) {
        URI retURI = null;
        if (uri != null) {
            retURI = uri.trimSegments(1);
        }
        return retURI;
    }

    public static String toValidFileName(String stValue) {
        String result = null;
        StringBuilder sb = new StringBuilder();
        if (stValue != null) {
            int size = stValue.length();
            int i = 0;
            while (i < size) {
                char c = stValue.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '-' && c != '_') {
                    sb.append('_');
                } else {
                    sb.append(c);
                }
                ++i;
            }
            result = sb.toString();
        }
        return result;
    }
}

