/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.frame.core.model.Review;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.WildcardFileFilter;

public class R4EInputValidator
implements IInputValidator {
    private static final String FOLDER_VALIDATION_ERROR_MESSAGE = "Folder does not exist";
    private static final String EMPTY_VALIDATION_ERROR_MESSAGE = "No Input given";
    private static final String GROUP_WILDCARD_NAME = "*_group_root.xrer";
    private static final String FOLDER_GROUP_EXISTS_VALIDATION_ERROR_MESSAGE = "Folder already contains a Group File";
    private static final String FILE_EXISTS_VALIDATION_ERROR_MESSAGE = "File already exists";
    private static final String REVIEW_EXISTS_VALIDATION_ERROR_MESSAGE = "A Review with the same name already exists within this Review Group";

    public String isFolderValid(String newText) {
        if (newText == null || newText.length() == 0) {
            return FOLDER_VALIDATION_ERROR_MESSAGE;
        }
        File folder = new File(newText);
        if (folder.exists()) {
            return null;
        }
        return FOLDER_VALIDATION_ERROR_MESSAGE;
    }

    public String isFolderEmpty(String newText) {
        File dir = new File(newText);
        File[] files = dir.listFiles(new WildcardFileFilter(GROUP_WILDCARD_NAME));
        if (files.length > 0) {
            return FOLDER_GROUP_EXISTS_VALIDATION_ERROR_MESSAGE;
        }
        return null;
    }

    public String isFileExists(String newText) {
        File file = new File(newText);
        if (file.exists()) {
            return FILE_EXISTS_VALIDATION_ERROR_MESSAGE;
        }
        return null;
    }

    public String isValid(String newText) {
        if (newText == null || newText.length() == 0) {
            return EMPTY_VALIDATION_ERROR_MESSAGE;
        }
        return null;
    }

    public String isReviewExists(String aReviewName, R4EUIReviewGroup aParentGroup) {
        for (Review review : aParentGroup.getReviewGroup().getReviews()) {
            if (!((R4EReview)review).getName().equalsIgnoreCase(aReviewName)) continue;
            return REVIEW_EXISTS_VALIDATION_ERROR_MESSAGE;
        }
        return null;
    }
}

