/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.script.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.ecl.context.EclContext;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.ecl.runtime.EclRuntime;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;

public class EclContextProcessor
implements IContextProcessor {
    private boolean applied = false;

    public Context create(EObject param) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void apply(Context context) throws CoreException {
        final EclContext eclContext = (EclContext)context;
        final Exception[] resultE = new Exception[1];
        final Boolean[] finished = new Boolean[]{false};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block21: {
                    ISession session = EclRuntime.createSession();
                    try {
                        try {
                            IProcess process = session.execute((Command)TeslaFactory.eINSTANCE.createSetupPlayer());
                            process.waitFor();
                            Script eclScript = eclContext.getScript() != null ? (Script)EcoreUtil.copy((EObject)eclContext.getScript()) : null;
                            process = session.execute((Command)eclScript);
                            IStatus status = process.waitFor();
                            if (!status.isOK() && status instanceof ScriptErrorStatus) {
                                ScriptErrorStatus st = (ScriptErrorStatus)status;
                                String msg = String.valueOf(st.getCause().getMessage()) + "\nWhile executing context " + eclContext.getName() + " at line:" + st.getLine();
                                ScriptErrorStatus sse = new ScriptErrorStatus(st.getPlugin(), msg, st.getResource(), st.getLine(), st.getColumn(), st.getLength());
                                sse.add(st.getCause());
                                resultE[0] = new CoreException((IStatus)sse);
                            } else if (!status.isOK()) {
                                resultE[0] = new CoreException(status);
                            }
                        }
                        catch (Exception e) {
                            resultE[0] = new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Failed to launch ECL context", (Throwable)e));
                            finished[0] = true;
                            try {
                                IProcess process = session.execute((Command)TeslaFactory.eINSTANCE.createShoutdownPlayer());
                                process.waitFor();
                            }
                            catch (Exception e2) {
                                resultE[0] = new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Failed to launch ECL context", (Throwable)e2));
                            }
                            if (session == null) break block21;
                            try {
                                session.close();
                            }
                            catch (Exception e3) {
                                resultE[0] = e3;
                            }
                        }
                    }
                    finally {
                        finished[0] = true;
                        try {
                            IProcess process = session.execute((Command)TeslaFactory.eINSTANCE.createShoutdownPlayer());
                            process.waitFor();
                        }
                        catch (Exception e) {
                            resultE[0] = new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Failed to launch ECL context", (Throwable)e));
                        }
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Exception e) {
                                resultE[0] = e;
                            }
                        }
                    }
                }
            }
        };
        Thread t = new Thread(r, "ECL Context apply");
        t.start();
        try {
            t.join(TeslaLimits.getContextRunnableTimeout());
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        if (!finished[0].booleanValue()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script", "Timeout exceeded during Ecl context execution..."));
        }
        if (resultE[0] != null) {
            if (!(resultE[0] instanceof CoreException)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.script.impl", resultE[0].getMessage(), (Throwable)resultE[0]));
            }
            throw (CoreException)resultE[0];
        }
        this.applied = true;
    }

    public boolean isApplied(Context context) {
        return this.applied;
    }
}

