/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.text.AnnotationHighlighter;
import org.eclipse.search2.internal.ui.text.EditorAccessHighlighter;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.MarkerHighlighter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorAnnotationManager
implements ISearchResultListener {
    private ArrayList fResults;
    private IEditorPart fEditor;
    private Highlighter fHighlighter;
    public static final int HIGHLLIGHTER_ANY = 0;
    public static final int HIGHLIGHTER_MARKER = 1;
    public static final int HIGHLIGHTER_ANNOTATION = 2;
    public static final int HIGHLIGHTER_EDITOR_ACCESS = 3;
    private static int fgHighlighterType = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public EditorAnnotationManager(IEditorPart editorPart) {
        Assert.isNotNull((Object)editorPart);
        this.fEditor = editorPart;
        this.fHighlighter = null;
        this.fResults = new ArrayList(3);
    }

    public static final void debugSetHighlighterType(int type) {
        fgHighlighterType = type;
    }

    void dispose() {
        this.removeAllAnnotations();
        if (this.fHighlighter != null) {
            this.fHighlighter.dispose();
        }
        int i = 0;
        while (i < this.fResults.size()) {
            ((AbstractTextSearchResult)this.fResults.get(i)).removeListener(this);
            ++i;
        }
        this.fResults.clear();
    }

    public synchronized void doEditorInputChanged() {
        this.removeAllAnnotations();
        if (this.fHighlighter != null) {
            this.fHighlighter.dispose();
            this.fHighlighter = null;
        }
        int i = 0;
        while (i < this.fResults.size()) {
            AbstractTextSearchResult curr = (AbstractTextSearchResult)this.fResults.get(i);
            this.addAnnotations(curr);
            ++i;
        }
    }

    public synchronized void setSearchResults(List results) {
        this.removeAllAnnotations();
        int i = 0;
        while (i < this.fResults.size()) {
            ((AbstractTextSearchResult)this.fResults.get(i)).removeListener(this);
            ++i;
        }
        this.fResults.clear();
        i = 0;
        while (i < results.size()) {
            this.addSearchResult((AbstractTextSearchResult)results.get(i));
            ++i;
        }
    }

    public synchronized void addSearchResult(AbstractTextSearchResult result) {
        this.fResults.add(result);
        result.addListener(this);
        this.addAnnotations(result);
    }

    public synchronized void removeSearchResult(AbstractTextSearchResult result) {
        this.fResults.remove(result);
        result.removeListener(this);
        this.removeAnnotations(result);
    }

    public synchronized void searchResultChanged(SearchResultEvent e) {
        ISearchResult searchResult = e.getSearchResult();
        if (searchResult instanceof AbstractTextSearchResult) {
            Match[] matchesInEditor;
            AbstractTextSearchResult result = (AbstractTextSearchResult)searchResult;
            if (e instanceof MatchEvent) {
                MatchEvent me = (MatchEvent)e;
                Match[] matchesInEditor2 = this.getMatchesInEditor(me.getMatches(), result);
                if (matchesInEditor2 != null) {
                    if (me.getKind() == 1) {
                        this.addAnnotations(matchesInEditor2);
                    } else {
                        this.removeAnnotations(matchesInEditor2);
                    }
                }
            } else if (e instanceof RemoveAllEvent) {
                this.removeAnnotations(result);
            } else if (e instanceof FilterUpdateEvent && (matchesInEditor = this.getMatchesInEditor(((FilterUpdateEvent)e).getUpdatedMatches(), result)) != null) {
                this.removeAnnotations(matchesInEditor);
                this.addAnnotations(matchesInEditor);
            }
        }
    }

    private Match[] getMatchesInEditor(Match[] matches, AbstractTextSearchResult result) {
        IEditorMatchAdapter adapter = result.getEditorMatchAdapter();
        if (adapter == null) {
            return null;
        }
        if (matches.length == 1) {
            return adapter.isShownInEditor(matches[0], this.fEditor) ? matches : null;
        }
        ArrayList<Match> matchesInEditor = null;
        int i = 0;
        while (i < matches.length) {
            Match curr = matches[i];
            if (adapter.isShownInEditor(curr, this.fEditor)) {
                if (matchesInEditor == null) {
                    matchesInEditor = new ArrayList<Match>();
                }
                matchesInEditor.add(curr);
            }
            ++i;
        }
        if (matchesInEditor != null) {
            return matchesInEditor.toArray(new Match[matchesInEditor.size()]);
        }
        return null;
    }

    private void removeAllAnnotations() {
        if (this.fHighlighter != null) {
            this.fHighlighter.removeAll();
        }
    }

    private Highlighter createHighlighter() {
        IFile file;
        ISearchEditorAccess access;
        IEditorPart editor = this.fEditor;
        if (fgHighlighterType != 0) {
            return EditorAnnotationManager.debugCreateHighlighter(editor);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.search.ui.text.ISearchEditorAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((access = (ISearchEditorAccess)editor.getAdapter((Class)clazz)) != null) {
            return new EditorAccessHighlighter(access);
        }
        IAnnotationModel model = EditorAnnotationManager.getAnnotationModel((IWorkbenchPart)editor);
        if (model != null) {
            return new AnnotationHighlighter(model, EditorAnnotationManager.getDocument((IWorkbenchPart)editor));
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            return new MarkerHighlighter(file);
        }
        return new Highlighter();
    }

    private static Highlighter debugCreateHighlighter(IEditorPart editor) {
        if (fgHighlighterType == 2) {
            IAnnotationModel model = EditorAnnotationManager.getAnnotationModel((IWorkbenchPart)editor);
            if (model != null) {
                return new AnnotationHighlighter(model, EditorAnnotationManager.getDocument((IWorkbenchPart)editor));
            }
        } else if (fgHighlighterType == 1) {
            IFile file;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
                return new MarkerHighlighter(file);
            }
        } else if (fgHighlighterType == 3) {
            ISearchEditorAccess access;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.search.ui.text.ISearchEditorAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((access = (ISearchEditorAccess)editor.getAdapter((Class)clazz)) != null) {
                return new EditorAccessHighlighter(access);
            }
        }
        return null;
    }

    private void addAnnotations(AbstractTextSearchResult result) {
        IEditorMatchAdapter matchAdapter = result.getEditorMatchAdapter();
        if (matchAdapter == null) {
            return;
        }
        Match[] matches = matchAdapter.computeContainedMatches(result, this.fEditor);
        if (matches == null || matches.length == 0) {
            return;
        }
        this.addAnnotations(matches);
    }

    private void removeAnnotations(AbstractTextSearchResult result) {
        this.removeAllAnnotations();
        int i = 0;
        while (i < this.fResults.size()) {
            AbstractTextSearchResult curr = (AbstractTextSearchResult)this.fResults.get(i);
            if (curr != result) {
                this.addAnnotations(curr);
            }
            ++i;
        }
    }

    private void addAnnotations(Match[] matches) {
        if (this.fHighlighter == null) {
            this.fHighlighter = this.createHighlighter();
        }
        this.fHighlighter.addHighlights(matches);
    }

    private void removeAnnotations(Match[] matches) {
        if (this.fHighlighter != null) {
            this.fHighlighter.removeHighlights(matches);
        }
    }

    private static IAnnotationModel getAnnotationModel(IWorkbenchPart part) {
        IAnnotationModel model = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.source.IAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((model = (IAnnotationModel)part.getAdapter((Class)clazz)) == null) {
            IDocumentProvider dp;
            ITextEditor textEditor = null;
            if (part instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
            }
            if (textEditor != null && (dp = textEditor.getDocumentProvider()) != null) {
                model = dp.getAnnotationModel((Object)textEditor.getEditorInput());
            }
        }
        return model;
    }

    private static IDocument getDocument(IWorkbenchPart part) {
        IDocument doc = null;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((doc = (IDocument)part.getAdapter((Class)clazz)) == null) {
            IDocumentProvider dp;
            ITextEditor textEditor = null;
            if (part instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
            }
            if (textEditor != null && (dp = textEditor.getDocumentProvider()) != null) {
                doc = dp.getDocument((Object)textEditor.getEditorInput());
            }
        }
        return doc;
    }
}

