/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.tags.TagsFactory;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.Q7ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.ProjectContextReferencesUpdateJob;
import org.eclipse.rcptt.ui.tags.impl.TagsWatcher;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Q7UIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.ui";
    private static Q7UIPlugin plugin;
    private TagsWatcher tagsWatcher;
    private TagsRegistry tags;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tags = TagsFactory.eINSTANCE.createTagsRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tagsWatcher != null) {
            RcpttCore.removeElementChangedListener((IElementChangedListener)this.tagsWatcher);
        }
        this.tagsWatcher = null;
        this.tags = null;
        plugin = null;
        super.stop(context);
    }

    public TagsRegistry getTags() {
        if (this.tagsWatcher == null) {
            this.tagsWatcher = new TagsWatcher(this.tags);
            RcpttCore.addElementChangedListener((IElementChangedListener)this.tagsWatcher);
        }
        return this.tags;
    }

    public static Q7UIPlugin getDefault() {
        return plugin;
    }

    public static void abort(String message, Throwable t) throws CoreException {
        throw new CoreException(Q7UIPlugin.createStatus(message, t));
    }

    public static void abort(String message) throws CoreException {
        throw new CoreException(Q7UIPlugin.createStatus(message));
    }

    public static void log(Throwable t) {
        Q7UIPlugin.log(t.getMessage(), t);
    }

    public static void log(String message, Throwable t) {
        Q7UIPlugin.getDefault().getLog().log(Q7UIPlugin.createStatus(message, t));
    }

    public static IStatus createStatus(String message) {
        return Q7UIPlugin.createStatus(message, null);
    }

    public static IStatus createStatus(Throwable t) {
        return Q7UIPlugin.createStatus(t.getMessage(), t);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }

    public static IWorkbenchWindow getActiveWindow() {
        IWorkbench workbench = Q7UIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow active = workbench.getActiveWorkbenchWindow();
        if (active == null) {
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            if (windows.length == 0) {
                throw new RuntimeException(Messages.Q7UIPlugin_NoActiveWindowErrorMsg);
            }
            return windows[0];
        }
        return active;
    }

    public static Display getDisplay() {
        Display display = null;
        if (PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void asyncExec(Runnable runnable) {
        Display display = Q7UIPlugin.getDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public static void syncExec(Runnable runnable) {
        Display display = Q7UIPlugin.getDisplay();
        if (display != null) {
            display.syncExec(runnable);
        }
    }

    public static boolean isInternalEdition() {
        return false;
    }

    public static boolean isImageRecognitionAllowed() {
        return false;
    }

    public static void initializeProjectContextUpdateJob() {
        RcpttCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(Q7ElementChangedEvent event) {
                IQ7NamedElement[] namedElements;
                IQ7ElementDelta delta = event.getDelta();
                IQ7NamedElement[] iQ7NamedElementArray = namedElements = delta.getNamedElements();
                int n = namedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement e = iQ7NamedElementArray[n2];
                    IQ7ElementDelta childDelta = delta.getChildBy(e);
                    switch (childDelta.getKind()) {
                        case 2: 
                        case 4: {
                            if (!(e instanceof Q7ProjectMetadata)) break;
                            ProjectContextReferencesUpdateJob job = new ProjectContextReferencesUpdateJob(e.getQ7Project());
                            Job.getJobManager().cancel(job.getFamily());
                            job.setRule((ISchedulingRule)e.getQ7Project().getProject());
                            job.schedule();
                        }
                    }
                    ++n2;
                }
            }
        });
    }
}

