/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.utils.AbstractFeatureManager;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeaturesComposite {
    private Map<AbstractFeatureManager.Option, Control> optionFields = new HashMap<AbstractFeatureManager.Option, Control>();
    private Runnable optionChangeCallback;
    private boolean groupping = true;
    private ScrolledComposite scrolledContainer;

    public void setOptionChangeCallback(Runnable optionChangeCallback) {
        this.optionChangeCallback = optionChangeCallback;
    }

    public Control createOptions(Composite content, String group, boolean autoApply, FormToolkit toolkit) {
        this.scrolledContainer = new ScrolledComposite(content, 512);
        this.scrolledContainer.setExpandHorizontal(true);
        if (toolkit != null) {
            toolkit.adapt((Composite)this.scrolledContainer);
        }
        this.scrolledContainer.getVerticalBar().setIncrement(10);
        final Composite compositeContainer = new Composite((Composite)this.scrolledContainer, 0);
        if (toolkit != null) {
            toolkit.adapt(compositeContainer);
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)compositeContainer);
        GridLayoutFactory.fillDefaults().applyTo(compositeContainer);
        this.scrolledContainer.setContent((Control)compositeContainer);
        this.createFeatures(compositeContainer, Messages.FeaturesComposite_CoreFeaturesGroup, (AbstractFeatureManager)Q7Features.getInstance(), group, autoApply, toolkit);
        this.createFeatures(compositeContainer, Messages.FeaturesComposite_RuntimeFeaturesGroup, (AbstractFeatureManager)TeslaFeatures.getInstance(), group, autoApply, toolkit);
        compositeContainer.setSize(compositeContainer.computeSize(-1, -1));
        IExpansionListener listener = new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                Point min = compositeContainer.computeSize(-1, -1);
                compositeContainer.setSize(min);
            }
        };
        this.recursivelyAddListener((Control)compositeContainer, listener);
        return this.scrolledContainer;
    }

    void recursivelyAddListener(Control control, IExpansionListener listener) {
        if (control instanceof ExpandableComposite) {
            ((ExpandableComposite)control).addExpansionListener(listener);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.recursivelyAddListener(child, listener);
                ++n2;
            }
        }
    }

    public void setDefaults() {
        for (Map.Entry<AbstractFeatureManager.Option, Control> opt : this.optionFields.entrySet()) {
            Control value = opt.getValue();
            AbstractFeatureManager.Option option = opt.getKey();
            if (value instanceof Button) {
                ((Button)value).setSelection("true".equals(option.getDefaultValue()));
                continue;
            }
            if (value instanceof Spinner) {
                ((Spinner)value).setSelection(Integer.parseInt(option.getDefaultValue()));
                continue;
            }
            if (value instanceof Combo) {
                ((Combo)value).setText(option.getDefaultValue());
                continue;
            }
            if (!(value instanceof Text)) continue;
            ((Text)value).setText(option.getDefaultValue());
        }
    }

    public void apply() {
        for (Map.Entry<AbstractFeatureManager.Option, Control> opt : this.optionFields.entrySet()) {
            this.applyValue(opt.getKey(), opt.getValue());
        }
        Q7Features.getInstance().saveToPreferences(RcpttPlugin.getPreferences());
        TeslaFeatures.getInstance().saveToPreferences(TeslaCore.getPreferences());
    }

    private void applyValue(AbstractFeatureManager.Option option, Control value) {
        if (value instanceof Button) {
            boolean selection = ((Button)value).getSelection();
            option.setValue(selection ? "true" : "false");
        } else if (value instanceof Spinner) {
            option.setValue(Integer.toString(((Spinner)value).getSelection()));
        } else if (value instanceof Combo) {
            int index = ((Combo)value).getSelectionIndex();
            option.setValue(option.getValues()[index]);
        } else if (value instanceof Text) {
            option.setValue(((Text)value).getText());
        }
        if (this.optionChangeCallback != null) {
            this.optionChangeCallback.run();
        }
    }

    public void createFeatures(Composite content, String title, AbstractFeatureManager features, String cfgGroup, boolean autoApply, FormToolkit toolkit) {
        AbstractFeatureManager.Option[] options = features.getOptions();
        TreeMap categories = new TreeMap();
        HashMap<String, Boolean> expanded = new HashMap<String, Boolean>();
        AbstractFeatureManager.Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeatureManager.Option key = optionArray[n2];
            if (key.isEditable() && key.isShowIn(cfgGroup)) {
                ArrayList<AbstractFeatureManager.Option> optionsList;
                String category = key.getCategory();
                if (category == null) {
                    category = "";
                }
                if (category.startsWith("$")) {
                    category = category.substring(1);
                    expanded.put(category, Boolean.TRUE);
                }
                if ((optionsList = (ArrayList<AbstractFeatureManager.Option>)categories.get(category)) == null) {
                    optionsList = new ArrayList<AbstractFeatureManager.Option>();
                }
                categories.put(category, optionsList);
                optionsList.add(key);
            }
            ++n2;
        }
        if (categories.isEmpty()) {
            return;
        }
        for (List optionsList : categories.values()) {
            Collections.sort(optionsList, new Comparator<AbstractFeatureManager.Option>(){

                @Override
                public int compare(AbstractFeatureManager.Option o1, AbstractFeatureManager.Option o2) {
                    return Integer.valueOf(o1.getOrder()).compareTo(o2.getOrder());
                }
            });
        }
        Composite parent = content;
        if (this.groupping) {
            Group mg = new Group(content, 0);
            if (toolkit != null) {
                toolkit.adapt((Composite)mg);
            }
            mg.setLayoutData((Object)new GridData(4, 4, true, true));
            mg.setText(title);
            mg.setLayout((Layout)new GridLayout(2, false));
            parent = mg;
        }
        for (Map.Entry entry : categories.entrySet()) {
            if (((List)entry.getValue()).size() == 0) continue;
            Composite g = null;
            if (((String)entry.getKey()).length() > 0 && this.groupping) {
                boolean expValue = expanded.containsKey(entry.getKey());
                Section exp = new Section(parent, 0x802 | (expValue ? 64 : 0));
                if (toolkit != null) {
                    toolkit.adapt((Composite)exp);
                }
                exp.setText((String)entry.getKey());
                exp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                g = new Composite((Composite)exp, 0);
                if (toolkit != null) {
                    toolkit.adapt(g);
                }
                g.setLayout((Layout)new GridLayout(2, false));
                exp.setClient((Control)g);
            } else {
                g = parent;
            }
            for (final AbstractFeatureManager.Option key : (List)entry.getValue()) {
                Spinner b;
                Label l;
                if (!key.isEditable() || !key.isShowIn(cfgGroup)) continue;
                String[] values = key.getValues();
                if (values != null && values.equals(AbstractFeatureManager.INT_VALUES)) {
                    l = new Label(g, 64);
                    l.setText(key.getName());
                    if (toolkit != null) {
                        toolkit.adapt((Control)l, false, false);
                    }
                    b = new Spinner(g, 2080);
                    if (toolkit != null) {
                        toolkit.adapt((Composite)b);
                    }
                    b.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 1000);
                    b.setSelection(Integer.parseInt(key.getValue()));
                    b.setToolTipText(key.getDescription());
                    b.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
                    this.optionFields.put(key, (Control)b);
                    if (key.getDescription() != null) {
                        l.setToolTipText(key.getDescription());
                    }
                    if (!autoApply) continue;
                    b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FeaturesComposite.this.applyValue(key, (Control)b);
                        }
                    });
                    continue;
                }
                if (values != null && values.equals(AbstractFeatureManager.BOOLEAN_VALUES)) {
                    final Button b2 = new Button(g, 32);
                    b2.setText(key.getName());
                    if (toolkit != null) {
                        toolkit.adapt((Control)b2, true, true);
                    }
                    b2.setToolTipText(key.getDescription());
                    b2.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
                    boolean value = "true".equals(key.getValue());
                    b2.setSelection(value);
                    this.optionFields.put(key, (Control)b2);
                    if (!autoApply) continue;
                    b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FeaturesComposite.this.applyValue(key, (Control)b2);
                        }
                    });
                    continue;
                }
                if (values != null) {
                    l = new Label(g, 0);
                    l.setText(key.getName());
                    if (toolkit != null) {
                        toolkit.adapt((Control)l, false, false);
                    }
                    b = new Combo(g, 76);
                    if (toolkit != null) {
                        toolkit.adapt((Composite)b);
                    }
                    b.setItems(values);
                    b.setText(key.getValue());
                    if (key.getDescription() != null) {
                        b.setToolTipText(key.getDescription());
                        l.setToolTipText(key.getDescription());
                    }
                    b.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
                    this.optionFields.put(key, (Control)b);
                    if (!autoApply) continue;
                    b.addModifyListener(new ModifyListener((Combo)b){
                        private final /* synthetic */ Combo val$b;
                        {
                            this.val$b = combo;
                        }

                        public void modifyText(ModifyEvent e) {
                            FeaturesComposite.this.applyValue(key, (Control)this.val$b);
                        }
                    });
                    continue;
                }
                l = new Label(g, 0);
                l.setText(key.getName());
                if (toolkit != null) {
                    toolkit.adapt((Control)l, false, false);
                }
                final Text value = new Text(g, 2048);
                if (toolkit != null) {
                    toolkit.adapt((Control)value, true, true);
                }
                if (key.getDescription() != null) {
                    value.setToolTipText(key.getDescription());
                    l.setToolTipText(key.getDescription());
                }
                value.setLayoutData((Object)new GridData(4, -1, true, false));
                if (key.getValue() != null) {
                    value.setText(key.getValue());
                }
                this.optionFields.put(key, (Control)value);
                if (!autoApply) continue;
                value.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        FeaturesComposite.this.applyValue(key, (Control)value);
                    }
                });
            }
        }
    }

    public void setGroupping(boolean b) {
        this.groupping = b;
    }
}

