/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Text;

public class CommitHelper {
    private Repository repository;
    boolean canCommit;
    String cannotCommitMessage;
    private RevCommit previousCommit;
    String author;
    String committer;
    boolean isMergedResolved;
    boolean isCherryPickResolved;
    private String commitMessage;

    public CommitHelper(Repository repository) {
        this.repository = repository;
        this.calculateCommitInfo();
    }

    private void calculateCommitInfo() {
        Repository mergeRepository = null;
        this.isMergedResolved = false;
        this.isCherryPickResolved = false;
        RepositoryState state = this.repository.getRepositoryState();
        this.canCommit = state.canCommit();
        if (!this.canCommit) {
            this.cannotCommitMessage = NLS.bind((String)UIText.CommitAction_repositoryState, (Object)state.getDescription());
            return;
        }
        if (state.equals((Object)RepositoryState.MERGING_RESOLVED)) {
            this.isMergedResolved = true;
            mergeRepository = this.repository;
        } else if (state.equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED)) {
            this.isCherryPickResolved = true;
            mergeRepository = this.repository;
        }
        this.previousCommit = CommitHelper.getHeadCommit(this.repository);
        UserConfig config = (UserConfig)this.repository.getConfig().get(UserConfig.KEY);
        this.author = config.getAuthorName();
        String authorEmail = config.getAuthorEmail();
        this.author = String.valueOf(this.author) + " <" + authorEmail + ">";
        this.committer = config.getCommitterName();
        String committerEmail = config.getCommitterEmail();
        this.committer = String.valueOf(this.committer) + " <" + committerEmail + ">";
        if (this.isMergedResolved || this.isCherryPickResolved) {
            this.commitMessage = this.getMergeResolveMessage(mergeRepository);
        }
        if (this.isCherryPickResolved) {
            this.author = CommitHelper.getCherryPickOriginalAuthor(mergeRepository);
        }
    }

    private static RevCommit getHeadCommit(Repository repository) {
        if (repository == null) {
            return null;
        }
        RevCommit headCommit = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk rw = new RevWalk(repository);){
                ObjectId parentId = repository.resolve("HEAD");
                if (parentId != null) {
                    headCommit = rw.parseCommit((AnyObjectId)parentId);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CommitAction_errorRetrievingCommit, e, true);
        }
        return headCommit;
    }

    private String getMergeResolveMessage(Repository mergeRepository) {
        try {
            String message = mergeRepository.readMergeCommitMsg();
            if (message != null) {
                return message;
            }
        }
        catch (IOException iOException) {}
        return NLS.bind((String)UIText.CommitHelper_couldNotFindMergeMsg, (Object)"MERGE_MSG");
    }

    private static String getCherryPickOriginalAuthor(Repository mergeRepository) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RevWalk rw = new RevWalk(mergeRepository);){
                ObjectId cherryPickHead = mergeRepository.readCherryPickHead();
                PersonIdent author = rw.parseCommit((AnyObjectId)cherryPickHead).getAuthorIdent();
                return String.valueOf(author.getName()) + " <" + author.getEmailAddress() + ">";
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CommitAction_errorRetrievingCommit, e, true);
            throw new IllegalStateException(e);
        }
    }

    public boolean canCommit() {
        return this.canCommit;
    }

    public String getCannotCommitMessage() {
        return this.cannotCommitMessage;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCommitter() {
        return this.committer;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public boolean isMergedResolved() {
        return this.isMergedResolved;
    }

    public boolean isCherryPickResolved() {
        return this.isCherryPickResolved;
    }

    public RevCommit getPreviousCommit() {
        return this.previousCommit;
    }

    public boolean amendAllowed() {
        return this.previousCommit != null && this.repository.getRepositoryState().canAmend();
    }

    public static boolean isCommitWithoutFilesAllowed(Repository repository) {
        RepositoryState state = repository.getRepositoryState();
        return state == RepositoryState.MERGING_RESOLVED;
    }

    public static CommitInfo getHeadCommitInfo(Repository repository) {
        RevCommit headCommit = CommitHelper.getHeadCommit(repository);
        if (headCommit == null) {
            return null;
        }
        String commitMessage = headCommit.getFullMessage().replaceAll("\n", Text.DELIMITER);
        PersonIdent authorIdent = headCommit.getAuthorIdent();
        String author = String.valueOf(authorIdent.getName()) + " <" + authorIdent.getEmailAddress() + ">";
        PersonIdent committerIdent = headCommit.getCommitterIdent();
        String committer = String.valueOf(committerIdent.getName()) + " <" + committerIdent.getEmailAddress() + ">";
        return new CommitInfo(headCommit, author, committer, commitMessage);
    }

    public static class CommitInfo {
        private RevCommit commit;
        private String author;
        private String committer;
        private String commitMessage;

        public CommitInfo(RevCommit commit, String author, String committer, String commitMessage) {
            this.commit = commit;
            this.author = author;
            this.committer = committer;
            this.commitMessage = commitMessage;
        }

        public RevCommit getCommit() {
            return this.commit;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getCommitter() {
            return this.committer;
        }

        public String getCommitMessage() {
            return this.commitMessage;
        }
    }
}

