/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchModelSynchronizeParticipant;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriber;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriberMergeContext;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class IgnoreLeadingPathSegmentsAction
extends Action {
    private ISynchronizePageConfiguration configuration;
    private ApplyPatchModelSynchronizeParticipant participant;
    private ApplyPatchSubscriberMergeContext context;
    private ApplyPatchSubscriber subscriber;
    private int maxValue;
    static /* synthetic */ Class class$0;

    public IgnoreLeadingPathSegmentsAction(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        this.participant = (ApplyPatchModelSynchronizeParticipant)configuration.getParticipant();
        this.context = (ApplyPatchSubscriberMergeContext)this.participant.getContext();
        this.subscriber = (ApplyPatchSubscriber)this.context.getSubscriber();
    }

    public boolean isEnabled() {
        return !this.subscriber.getPatcher().isWorkspacePatch();
    }

    public void run() {
        String input;
        int newValue;
        int oldValue = this.subscriber.getPatcher().getStripPrefixSegments();
        this.maxValue = this.subscriber.getPatcher().calculatePrefixSegmentCount() - 1;
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), TeamUIMessages.IgnoreLeadingPathSegmentsDialog_title, NLS.bind((String)TeamUIMessages.IgnoreLeadingPathSegmentsDialog_message, (Object)new Integer(this.maxValue)), new Integer(oldValue).toString(), new IInputValidator(){

            public String isValid(String input) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0 || i > IgnoreLeadingPathSegmentsAction.this.maxValue) {
                        return TeamUIMessages.IgnoreLeadingPathSegmentsDialog_numberOutOfRange;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return TeamUIMessages.IgnoreLeadingPathSegmentsDialog_notANumber;
                }
                return null;
            }
        });
        if (dlg.open() == 0 && (newValue = Integer.parseInt(input = dlg.getValue())) != oldValue) {
            DiffTree tree = (DiffTree)this.context.getDiffTree();
            tree.clear();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SubscriberDiffTreeEventHandler handler = (SubscriberDiffTreeEventHandler)this.context.getAdapter(clazz);
            handler.reset();
            this.subscriber.getPatcher().setStripPrefixSegments(newValue);
            this.participant.refresh(this.configuration.getSite().getWorkbenchSite(), this.context.getScope().getMappings());
        }
    }
}

