/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.feature.FeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class FeatureUndoManager
extends ModelUndoManager {
    public FeatureUndoManager(PDEFormEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    @Override
    protected String getPageId(Object obj) {
        if (obj instanceof IFeature || obj instanceof IFeatureURL) {
            return "feature";
        }
        if (obj instanceof IFeaturePlugin) {
            return "reference";
        }
        if (obj instanceof IFeatureImport) {
            return "dependencies";
        }
        return null;
    }

    @Override
    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        IFeatureModel model = (IFeatureModel)event.getChangeProvider();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(IFeatureModel model, Object[] elements) {
        IFeature feature = model.getFeature();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IFeaturePlugin) {
                    feature.addPlugins(new IFeaturePlugin[]{(IFeaturePlugin)element});
                } else if (element instanceof IFeatureImport) {
                    feature.addImports(new IFeatureImport[]{(IFeatureImport)element});
                } else if (element instanceof IFeatureChild) {
                    feature.addIncludedFeatures(new IFeatureChild[]{(IFeatureChild)element});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(IFeatureModel model, Object[] elements) {
        IFeature feature = model.getFeature();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IFeaturePlugin) {
                    feature.removePlugins(new IFeaturePlugin[]{(IFeaturePlugin)element});
                } else if (element instanceof IFeatureImport) {
                    feature.removeImports(new IFeatureImport[]{(IFeatureImport)element});
                } else if (element instanceof IFeatureChild) {
                    feature.removeIncludedFeatures(new IFeatureChild[]{(IFeatureChild)element});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof FeatureObject) {
            FeatureObject pobj = (FeatureObject)element;
            try {
                pobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        IFeatureObject fobj;
        Object obj;
        if (event.getChangeType() == 3 && (obj = event.getChangedObjects()[0]) instanceof IFeatureObject && !((fobj = (IFeatureObject)event.getChangedObjects()[0]) instanceof IFeature) && !fobj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }
}

