/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class FetchOperationUI {
    private final Repository repository;
    private final FetchOperation op;
    private final String sourceString;

    public FetchOperationUI(Repository repository, RemoteConfig config, int timeout, boolean dryRun) {
        this.repository = repository;
        this.op = new FetchOperation(repository, config, timeout, dryRun);
        this.sourceString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)config.getName());
    }

    public FetchOperationUI(Repository repository, URIish uri, List<RefSpec> specs, int timeout, boolean dryRun) {
        this.repository = repository;
        this.op = new FetchOperation(repository, uri, specs, timeout, dryRun);
        this.sourceString = uri.toPrivateString();
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.op.setCredentialsProvider(credentialsProvider);
    }

    public void setTagOpt(TagOpt tagOpt) {
        this.op.setTagOpt(tagOpt);
    }

    public FetchResult execute(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.op.getCredentialsProvider() == null) {
                this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
            }
            this.op.run(monitor);
            return this.op.getOperationResult();
        }
        catch (InvocationTargetException e) {
            throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
        }
    }

    public void start() {
        WorkspaceJob job = new WorkspaceJob(NLS.bind((String)UIText.FetchOperationUI_FetchJobName, (Object)this.sourceString)){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    FetchOperationUI.this.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.FETCH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    FetchResultDialog.show(FetchOperationUI.this.repository, FetchOperationUI.this.op.getOperationResult(), FetchOperationUI.this.sourceString);
                } else {
                    Activator.handleError(event.getResult().getMessage(), event.getResult().getException(), true);
                }
            }
        });
    }

    public String getSourceString() {
        return this.sourceString;
    }
}

