/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.handlers.HandlerUtil;

public class CheckoutCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        BranchSelectionDialog<Ref> dlg;
        List<Ref> nodes;
        ObjectId commitId = this.getSelectedCommitId(event);
        Repository repo = this.getRepository(event);
        try {
            nodes = this.getBranchesOfCommit(this.getSelection(event), repo, true);
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.AbstractHistoryCommitHandler_cantGetBranches, (Throwable)e);
        }
        BranchOperationUI op = nodes.isEmpty() ? BranchOperationUI.checkout(repo, commitId.name()) : (nodes.size() == 1 ? BranchOperationUI.checkout(repo, nodes.get(0).getName()) : ((dlg = new BranchSelectionDialog<Ref>(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), nodes, UIText.CheckoutHandler_SelectBranchTitle, UIText.CheckoutHandler_SelectBranchMessage, 4)).open() == 0 ? BranchOperationUI.checkout(repo, dlg.getSelectedNode().getName()) : null));
        if (op == null) {
            return null;
        }
        op.start();
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection sel = this.getSelection(page);
        return sel.size() == 1 && sel.getFirstElement() instanceof RevCommit;
    }
}

