/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.targetdefinition.ContentPage;
import org.eclipse.pde.internal.ui.editor.targetdefinition.DefinitionPage;
import org.eclipse.pde.internal.ui.editor.targetdefinition.EnvironmentPage;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.TargetContentsGroup;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationsGroup;
import org.eclipse.pde.internal.ui.wizards.exports.TargetDefinitionExportWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;

public class TargetEditor
extends FormEditor {
    private List<IManagedForm> fManagedFormPages = new ArrayList<IManagedForm>(2);
    private InputHandler fInputHandler = new InputHandler();
    private TargetChangedListener fTargetChangedListener;
    private boolean fDirty;

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(PDEPlugin.getDefault().getFormColors(display));
    }

    protected void addPages() {
        try {
            this.setActiveEditor((IEditorPart)this);
            this.addPage((IFormPage)new DefinitionPage(this));
            this.addPage((IFormPage)new ContentPage(this));
            this.addPage((IFormPage)new EnvironmentPage(this));
        }
        catch (PartInitException e) {
            PDEPlugin.log(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        try {
            this.fInputHandler.saveTargetDefinition();
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
            this.showError(PDEUIMessages.TargetEditor_3, e);
        }
    }

    public void doSaveAs() {
        this.commitPages(true);
        ITargetDefinition target = this.getTarget();
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        dialog.create();
        dialog.setMessage(PDEUIMessages.TargetEditor_0, 0);
        if (target.getHandle() instanceof WorkspaceFileTargetHandle) {
            WorkspaceFileTargetHandle currentTargetHandle = (WorkspaceFileTargetHandle)target.getHandle();
            dialog.setOriginalFile(currentTargetHandle.getTargetFile());
        }
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        if (!"target".equalsIgnoreCase(path.getFileExtension())) {
            path = path.addFileExtension("target");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(path);
        if (workspace.validateEdit(new IFile[]{file}, (Object)this.getSite().getShell()).isOK()) {
            try {
                WorkspaceFileTargetHandle newFileTarget = new WorkspaceFileTargetHandle(file);
                newFileTarget.save(target);
                this.setInput((IEditorInput)new FileEditorInput(file));
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
                this.showError(PDEUIMessages.TargetEditor_3, e);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setDirty(boolean dirty) {
        this.fDirty = this.fDirty || dirty;
        this.editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.fDirty || super.isDirty();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput) && !(input instanceof IURIEditorInput)) {
            throw new PartInitException(NLS.bind((String)PDEUIMessages.TargetEditor_6, (Object)input.getClass().getName()));
        }
        super.init(site, input);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(this.getEditorInput().getName());
        this.fInputHandler.setInput(input);
    }

    public void dispose() {
        Job.getJobManager().cancel(this.getTargetChangedListener().getJobFamily());
        this.getTargetChangedListener().setContentTree(null);
        this.getTargetChangedListener().setLocationTree(null);
        this.fInputHandler.dispose();
        super.dispose();
    }

    public ITargetDefinition getTarget() {
        return this.fInputHandler.getTarget();
    }

    public TargetChangedListener getTargetChangedListener() {
        if (this.fTargetChangedListener == null) {
            this.fTargetChangedListener = new TargetChangedListener();
        }
        return this.fTargetChangedListener;
    }

    public void doRevert() {
        this.fInputHandler.reset();
        Iterator<IManagedForm> iterator = this.fManagedFormPages.iterator();
        while (iterator.hasNext()) {
            IFormPart[] parts = iterator.next().getParts();
            int i = 0;
            while (i < parts.length) {
                if (parts[i] instanceof AbstractFormPart) {
                    ((AbstractFormPart)parts[i]).markStale();
                }
                ++i;
            }
        }
        this.setActivePage(this.getActivePage());
        this.editorDirtyStateChanged();
    }

    public void contributeToToolbar(final ScrolledForm form, String contextID) {
        ControlContribution setAsTarget = new ControlContribution("Set"){

            protected Control createControl(Composite parent) {
                final ImageHyperlink hyperlink = new ImageHyperlink(parent, 0);
                hyperlink.setText(PDEUIMessages.AbstractTargetPage_setTarget);
                hyperlink.setUnderlined(true);
                hyperlink.setForeground(TargetEditor.this.getToolkit().getHyperlinkGroup().getForeground());
                hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        LoadTargetDefinitionJob.load((ITargetDefinition)TargetEditor.this.getTarget());
                    }

                    public void linkEntered(HyperlinkEvent e) {
                        HyperlinkGroup hyperlinkGroup = this.getHyperlinkGroup();
                        if (hyperlinkGroup != null) {
                            hyperlink.setForeground(hyperlinkGroup.getActiveForeground());
                        }
                    }

                    public void linkExited(HyperlinkEvent e) {
                        HyperlinkGroup hyperlinkGroup = this.getHyperlinkGroup();
                        if (hyperlinkGroup != null) {
                            hyperlink.setForeground(hyperlinkGroup.getForeground());
                        }
                    }

                    private HyperlinkGroup getHyperlinkGroup() {
                        FormToolkit toolkit = TargetEditor.this.getToolkit();
                        HyperlinkGroup hyperlinkGroup = null;
                        if (toolkit != null) {
                            hyperlinkGroup = toolkit.getHyperlinkGroup();
                        }
                        return hyperlinkGroup;
                    }
                });
                return hyperlink;
            }
        };
        final String helpContextID = contextID;
        Action help = new Action("help"){

            public void run() {
                BusyIndicator.showWhile((Display)form.getForm().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextID);
                    }
                });
            }
        };
        help.setToolTipText(PDEUIMessages.PDEFormPage_help);
        help.setImageDescriptor(PDEPluginImages.DESC_HELP);
        Action export = new Action("export"){

            public void run() {
                TargetDefinitionExportWizard wizard = new TargetDefinitionExportWizard(TargetEditor.this.getTarget());
                wizard.setWindowTitle(PDEUIMessages.ExportActiveTargetDefinition);
                WizardDialog dialog = new WizardDialog(TargetEditor.this.getSite().getShell(), (IWizard)wizard);
                dialog.open();
            }
        };
        export.setToolTipText("Export");
        export.setImageDescriptor(PDEPluginImages.DESC_EXPORT_TARGET_TOOL);
        form.getToolBarManager().add((IContributionItem)setAsTarget);
        form.getToolBarManager().add((IAction)export);
        form.getToolBarManager().add((IAction)help);
        form.updateToolBar();
    }

    public void addForm(IManagedForm managedForm) {
        this.fManagedFormPages.add(managedForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm().getBody(), "org.eclipse.pde.doc.user.target_editor");
    }

    public void showError(final String message, final CoreException exception) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)TargetEditor.this.getSite().getShell(), (String)PDEUIMessages.TargetEditor_4, (String)message, (IStatus)exception.getStatus());
            }
        });
    }

    private class InputHandler
    implements IResourceChangeListener {
        private IEditorInput fInput;
        private ITargetDefinition fTarget;
        private IFile fTargetFileInWorkspace;
        private boolean fSaving = false;

        private InputHandler() {
        }

        public void dispose() {
            PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public void reset() {
            this.setInput(this.fInput);
        }

        public void setInput(IEditorInput input) {
            this.fInput = input;
            this.fTargetFileInWorkspace = null;
            this.fTarget = null;
            File targetFile = null;
            if (input instanceof IFileEditorInput) {
                this.fTargetFileInWorkspace = ((IFileEditorInput)input).getFile();
                targetFile = this.fTargetFileInWorkspace.getLocation().toFile();
            } else if (input instanceof IURIEditorInput) {
                String part = ((IURIEditorInput)input).getURI().getSchemeSpecificPart();
                Path path = new Path(part);
                this.fTargetFileInWorkspace = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                targetFile = path.toFile();
            }
            if (this.fTargetFileInWorkspace == null || targetFile == null || !targetFile.exists()) {
                TargetEditor.this.close(false);
            }
            PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        public ITargetDefinition getTarget() {
            if (this.fTarget == null) {
                try {
                    this.loadTargetDefinition();
                    TargetEditor.this.fDirty = false;
                    TargetEditor.this.editorDirtyStateChanged();
                }
                catch (CoreException e) {
                    TargetEditor.this.showError(PDEUIMessages.TargetEditor_5, e);
                    TargetEditor.this.close(false);
                }
            }
            return this.fTarget;
        }

        private ITargetDefinition loadTargetDefinition() throws CoreException {
            ITargetPlatformService service = this.getTargetPlatformService();
            try {
                if (this.fInput instanceof IFileEditorInput) {
                    ITargetHandle fileHandle = service.getTarget(((IFileEditorInput)this.fInput).getFile());
                    this.fTarget = fileHandle.getTargetDefinition();
                } else if (this.fInput instanceof IURIEditorInput) {
                    ITargetHandle externalTarget = service.getTarget(((IURIEditorInput)this.fInput).getURI());
                    this.fTarget = externalTarget.getTargetDefinition();
                }
            }
            catch (CoreException e) {
                this.fTarget = service.newTarget();
                throw e;
            }
            TargetEditor.this.getTargetChangedListener().contentsChanged(this.fTarget, this, true, false);
            return this.fTarget;
        }

        public void saveTargetDefinition() throws CoreException {
            ITargetPlatformService service = this.getTargetPlatformService();
            this.fSaving = true;
            try {
                service.saveTargetDefinition(this.fTarget);
                TargetEditor.this.fDirty = false;
                TargetEditor.this.editorDirtyStateChanged();
            }
            finally {
                this.fSaving = false;
            }
        }

        private ITargetPlatformService getTargetPlatformService() throws CoreException {
            ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
            if (service == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "ITargetPlatformService not available"));
            }
            return service;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta;
            if (event.getType() == 1 && (delta = event.getDelta().findMember(this.fTargetFileInWorkspace.getFullPath())) != null) {
                if (delta.getKind() == 2) {
                    TargetEditor.this.close(false);
                } else if (!(delta.getKind() != 4 && delta.getKind() != 262144 || this.fSaving)) {
                    Display display = TargetEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TargetEditor.this.doRevert();
                        }
                    });
                }
            }
        }
    }

    class TargetChangedListener
    implements ITargetChangedListener {
        private TargetLocationsGroup fLocationTree;
        private TargetContentsGroup fContentTree;
        private Object fJobFamily = new Object();

        TargetChangedListener() {
        }

        public void setLocationTree(TargetLocationsGroup locationTree) {
            this.fLocationTree = locationTree;
        }

        public void setContentTree(TargetContentsGroup contentTree) {
            this.fContentTree = contentTree;
        }

        public Object getJobFamily() {
            return this.fJobFamily;
        }

        @Override
        public void contentsChanged(ITargetDefinition definition, Object source, boolean resolve, boolean forceResolve) {
            if (!(forceResolve || resolve && !definition.isResolved())) {
                if (this.fContentTree != null && source != this.fContentTree) {
                    ITargetDefinition target = TargetEditor.this.getTarget();
                    if (target != null && target.isResolved()) {
                        this.fContentTree.setInput(TargetEditor.this.getTarget());
                    } else if (Job.getJobManager().find(this.getJobFamily()).length > 0) {
                        this.fContentTree.setInput(null);
                    } else {
                        this.fContentTree.setCancelled();
                    }
                }
                if (this.fLocationTree != null && source != this.fLocationTree) {
                    this.fLocationTree.setInput(TargetEditor.this.getTarget());
                }
            } else {
                if (this.fContentTree != null) {
                    this.fContentTree.setInput(null);
                }
                if (this.fLocationTree != null) {
                    this.fLocationTree.setInput(TargetEditor.this.getTarget());
                }
                Job.getJobManager().cancel(this.getJobFamily());
                Job resolveJob = new Job(PDEUIMessages.TargetEditor_1){

                    protected IStatus run(IProgressMonitor monitor) {
                        TargetEditor.this.getTarget().resolve(monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return family.equals(TargetChangedListener.this.getJobFamily());
                    }
                };
                resolveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        final IStatus status = event.getResult();
                        UIJob job = new UIJob(PDEUIMessages.TargetEditor_2){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (TargetChangedListener.this.fContentTree != null) {
                                    if (status.getSeverity() == 8) {
                                        TargetChangedListener.this.fContentTree.setCancelled();
                                    } else {
                                        TargetChangedListener.this.fContentTree.setInput(TargetEditor.this.getTarget());
                                    }
                                }
                                if (TargetChangedListener.this.fLocationTree != null) {
                                    TargetChangedListener.this.fLocationTree.setInput(TargetEditor.this.getTarget());
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.setSystem(true);
                        job.schedule();
                    }
                });
                resolveJob.schedule();
            }
        }
    }
}

