/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.internal.core.text.plugin.PluginNode;

public class ExtensionsFilterUtil {
    public static final String[] RELATED_ATTRIBUTES = new String[]{"id", "class", "commandId", "pattern", "locationURI", "defaultHandler", "variable", "property", "contentTypeId", "path", "plugin", "perspective", "targetID"};
    public static final String ATTRIBUTE_ACTIVITYID = "activityId";
    public static final String ATTRIBUTE_CATEGORY = "category";
    public static final String ATTRIBUTE_CATEGORYID = "categoryId";
    public static final String ATTRIBUTE_COMMANDID = "commandId";
    public static final String ATTRIBUTE_DEFAULTHANDLER = "defaultHandler";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_MNEMONIC = "mnemonic";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_NAMESPACE = "namespace";
    public static final String ATTRIBUTE_PROPERTIES = "properties";
    public static final String ATTRIBUTE_PATTERN = "pattern";
    public static final String ATTRIBUTE_REQUIREDACTIVITYID = "requiredActivityId";
    public static final String ATTRIBUTE_TOOLTIP = "tooltip";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ELEMENT_ACATEGORY = "org.eclipse.ui.activities.category";
    public static final String ELEMENT_ACTIVITY = "org.eclipse.ui.activities.activity";
    public static final String ELEMENT_AR_BINDING = "org.eclipse.ui.activities.activityRequirementBinding";
    public static final String ELEMENT_CA_BINDING = "org.eclipse.ui.activities.categoryActivityBinding";
    public static final String ELEMENT_COMMAND = "org.eclipse.ui.commands.command";
    public static final String ELEMENT_EQUALS = "equals";
    public static final String ELEMENT_HELP_TOC = "org.eclipse.help.toc.toc";
    public static final String ELEMENT_INSTANCEOF = "instanceof";
    public static final String ELEMENT_MENU_COMMAND = "org.eclipse.ui.menus.command";
    public static final String ELEMENT_PARAMETER = "parameter";
    public static final String ELEMENT_PATTERNBINDING = "org.eclipse.ui.activities.activityPatternBinding";
    public static final String ELEMENT_PROPERTYTESTER = "org.eclipse.core.expressions.propertyTesters.propertyTester";
    public static final String ELEMENT_VARIABLE = "variable";
    public static final String[] HIGH_PRIORITY_ELEMENTS = new String[]{"org.eclipse.ui.commands.command", "org.eclipse.ui.menus.command", "instanceof", "equals"};
    public static final String[] LOW_PRIORITY_ELEMENTS = new String[]{"parameter", "org.eclipse.ui.activities.categoryActivityBinding", "org.eclipse.ui.activities.activityRequirementBinding", "variable", "org.eclipse.help.toc.toc"};
    public static final String[] RESOURCE_ATTRIBUTES = new String[]{"label", "name", "tooltip", "mnemonic", "description"};
    public static final Map<String, String[]> CUSTOM_RELATIONS = new HashMap<String, String[]>();
    private static String BOOLEAN_TRUE;
    private static String BOOLEAN_FALSE;
    private static String ADDITIONS;

    static {
        CUSTOM_RELATIONS.put(ELEMENT_COMMAND, new String[]{ATTRIBUTE_ID, ATTRIBUTE_DEFAULTHANDLER});
        CUSTOM_RELATIONS.put(ELEMENT_INSTANCEOF, new String[]{ATTRIBUTE_VALUE});
        CUSTOM_RELATIONS.put(ELEMENT_EQUALS, new String[]{ATTRIBUTE_VALUE});
        CUSTOM_RELATIONS.put(ELEMENT_PARAMETER, new String[]{ATTRIBUTE_NAME});
        CUSTOM_RELATIONS.put(ELEMENT_VARIABLE, new String[]{ATTRIBUTE_NAME});
        CUSTOM_RELATIONS.put(ELEMENT_MENU_COMMAND, new String[]{ATTRIBUTE_COMMANDID, ATTRIBUTE_ID});
        CUSTOM_RELATIONS.put(ELEMENT_CA_BINDING, new String[]{ATTRIBUTE_ACTIVITYID, ATTRIBUTE_CATEGORYID});
        CUSTOM_RELATIONS.put(ELEMENT_AR_BINDING, new String[]{ATTRIBUTE_REQUIREDACTIVITYID, ATTRIBUTE_ACTIVITYID});
        CUSTOM_RELATIONS.put(ELEMENT_HELP_TOC, new String[]{ATTRIBUTE_CATEGORY});
        BOOLEAN_TRUE = "true";
        BOOLEAN_FALSE = "false";
        ADDITIONS = "additions";
    }

    public static boolean add(Set<String> pattern, IPluginElement pluginElement, String attributeName) {
        IPluginAttribute attribute = pluginElement.getAttribute(attributeName);
        if (attribute != null) {
            return ExtensionsFilterUtil.add(pattern, attribute.getValue());
        }
        return false;
    }

    public static boolean add(Set<String> pattern, String value) {
        String trimmed;
        if (value != null && value.length() > 0 && !ExtensionsFilterUtil.isBoolean(trimmed = value.trim())) {
            return pattern.add(trimmed);
        }
        return false;
    }

    public static void addAll(Set<String> pattern, IPluginElement pluginElement, String elementName) {
        String[] attributes = CUSTOM_RELATIONS.get(elementName);
        if (attributes != null) {
            String[] attributesArray = attributes;
            int i = 0;
            while (i < attributesArray.length) {
                ExtensionsFilterUtil.add(pattern, pluginElement, attributesArray[i]);
                ++i;
            }
        }
    }

    public static String getElementPath(IPluginElement pluginElement) {
        IPluginElement element = pluginElement;
        while (element.getParent() != null && !(element.getParent() instanceof PluginNode)) {
            element = element.getParent();
        }
        if (element instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)element;
            return String.valueOf(extension.getPoint()) + '.' + pluginElement.getName();
        }
        return null;
    }

    public static String getFilterRelatedPattern(IStructuredSelection selection) {
        Iterator it = selection.iterator();
        HashSet<String> filterPatterns = new HashSet<String>();
        while (it.hasNext()) {
            Object treeElement = it.next();
            if (!(treeElement instanceof IPluginElement)) continue;
            IPluginElement pluginElement = (IPluginElement)treeElement;
            Set<String> customAttributes = ExtensionsFilterUtil.getCustomRelations(pluginElement);
            if (customAttributes.size() == 0) {
                int n = 0;
                while (n < RELATED_ATTRIBUTES.length) {
                    String property = RELATED_ATTRIBUTES[n];
                    IPluginAttribute attribute = pluginElement.getAttribute(property);
                    if (attribute != null && attribute.getValue() != null && attribute.getValue().length() > 0) {
                        String value = attribute.getValue();
                        if (!value.startsWith("%")) {
                            int delimiterPosition = value.indexOf(63);
                            if (delimiterPosition == -1) {
                                if (!ExtensionsFilterUtil.isBoolean(value)) {
                                    filterPatterns.add(value);
                                }
                            } else {
                                String placeHolder;
                                filterPatterns.add(value.substring(0, delimiterPosition));
                                int position = value.lastIndexOf(61);
                                if (position != -1 && !(placeHolder = value.substring(position + 1, value.length())).equalsIgnoreCase(ADDITIONS)) {
                                    filterPatterns.add(placeHolder);
                                }
                            }
                        } else {
                            String resourceValue = pluginElement.getResourceString(value);
                            if (resourceValue != null && resourceValue.length() > 0) {
                                filterPatterns.add(resourceValue);
                            }
                        }
                    }
                    ++n;
                }
                continue;
            }
            filterPatterns.addAll(customAttributes);
        }
        StringBuffer patternBuffer = new StringBuffer();
        int attributeCount = 0;
        for (Object e : filterPatterns) {
            if (++attributeCount >= 30 || e == null) continue;
            patternBuffer.append(e);
            patternBuffer.append('/');
        }
        String filterPattern = patternBuffer.toString();
        if (filterPattern.endsWith("/")) {
            filterPattern = filterPattern.substring(0, filterPattern.length() - 1);
        }
        return filterPattern;
    }

    public static Set<String> getCustomRelations(IPluginElement pluginElement) {
        String elementName;
        Set<String> customAttributes = new TreeSet<String>();
        String string = elementName = pluginElement != null ? ExtensionsFilterUtil.getElementPath(pluginElement) : null;
        if (elementName == null) {
            return customAttributes;
        }
        if (!ExtensionsFilterUtil.addMatchingElements(customAttributes, pluginElement, elementName, HIGH_PRIORITY_ELEMENTS)) {
            if (ELEMENT_ACTIVITY.equalsIgnoreCase(elementName) || ELEMENT_ACATEGORY.equals(elementName)) {
                if (!ExtensionsFilterUtil.add(customAttributes, pluginElement, ATTRIBUTE_ID)) {
                    ExtensionsFilterUtil.add(customAttributes, pluginElement, ATTRIBUTE_NAME);
                }
            } else if (ELEMENT_PROPERTYTESTER.equalsIgnoreCase(elementName)) {
                customAttributes = ExtensionsFilterUtil.handlePropertyTester(customAttributes, pluginElement);
                ExtensionsFilterUtil.add(customAttributes, pluginElement, ATTRIBUTE_ID);
            } else if (ELEMENT_PATTERNBINDING.equals(elementName)) {
                int lastSeparator;
                ExtensionsFilterUtil.add(customAttributes, pluginElement, ATTRIBUTE_ACTIVITYID);
                String attributeValue = pluginElement.getAttribute(ATTRIBUTE_PATTERN).getValue();
                if (attributeValue.length() > 0 && (lastSeparator = attributeValue.lastIndexOf(47)) > 0 && attributeValue.length() > lastSeparator + 1) {
                    customAttributes.add(attributeValue.substring(lastSeparator + 1, attributeValue.length()));
                }
            } else {
                ExtensionsFilterUtil.addMatchingElements(customAttributes, pluginElement, elementName, LOW_PRIORITY_ELEMENTS);
            }
        }
        return customAttributes;
    }

    private static boolean addMatchingElements(Set<String> customAttributes, IPluginElement pluginElement, String elementName, String[] elements) {
        boolean elementMatch = false;
        if (elementName != null) {
            int i = 0;
            while (i < elements.length) {
                if (elementName.endsWith(elements[i])) {
                    ExtensionsFilterUtil.addAll(customAttributes, pluginElement, elements[i]);
                    elementMatch = true;
                }
                ++i;
            }
        }
        return elementMatch;
    }

    private static Set<String> handlePropertyTester(Set<String> customAttributes, IPluginElement pluginElement) {
        String namespace = pluginElement.getAttribute(ATTRIBUTE_NAMESPACE).getValue();
        String properties = pluginElement.getAttribute(ATTRIBUTE_PROPERTIES).getValue();
        if (namespace.length() > 0) {
            String[] propertiesArray = properties.split(",");
            int i = 0;
            while (i < propertiesArray.length) {
                String property = propertiesArray[i].trim();
                if (property.length() > 0) {
                    customAttributes.add(String.valueOf(namespace) + '.' + property);
                }
                ++i;
            }
            if (propertiesArray.length == 0) {
                customAttributes.add(namespace);
            }
        }
        return customAttributes;
    }

    public static List<String> handlePropertyTester(IPluginElement pluginElement) {
        ArrayList<String> propertyTestAttributes = new ArrayList<String>();
        if (ExtensionsFilterUtil.isElementNameMatch(pluginElement, ELEMENT_PROPERTYTESTER)) {
            Set<String> attributes = ExtensionsFilterUtil.handlePropertyTester(new HashSet<String>(), pluginElement);
            Iterator<String> iterator = attributes.iterator();
            while (iterator.hasNext()) {
                propertyTestAttributes.add(iterator.next());
            }
        }
        return propertyTestAttributes;
    }

    public static boolean isElementNameMatch(IPluginElement pluginElement, String expected) {
        String elementName = ExtensionsFilterUtil.getElementPath(pluginElement);
        return elementName == null ? expected.endsWith(pluginElement.getName()) : elementName.endsWith(expected);
    }

    public static boolean isAttributeNameMatch(String attributeName, String[] matches) {
        int i = 0;
        while (i < matches.length) {
            String matchingAttribute = matches[i];
            if (matchingAttribute.equals(attributeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isFilterRelatedEnabled(IPluginElement pluginElement) {
        int i = 0;
        while (i < RELATED_ATTRIBUTES.length) {
            String property = RELATED_ATTRIBUTES[i];
            IPluginAttribute attribute = pluginElement.getAttribute(property);
            if (attribute != null) {
                return true;
            }
            ++i;
        }
        String elementName = ExtensionsFilterUtil.getElementPath(pluginElement);
        if (elementName != null) {
            Set<String> keySet = CUSTOM_RELATIONS.keySet();
            for (String key : keySet) {
                String[] attributes;
                if (!elementName.endsWith(key) || (attributes = CUSTOM_RELATIONS.get(key)) == null) continue;
                String[] attributesArray = attributes;
                int i2 = 0;
                while (i2 < attributesArray.length) {
                    IPluginAttribute attribute = pluginElement.getAttribute(attributesArray[i2]);
                    if (attribute != null) {
                        return true;
                    }
                    ++i2;
                }
            }
        }
        return false;
    }

    public static boolean isFilterRelatedEnabled(IStructuredSelection structuredSelection) {
        boolean createFilterRelatedAction = false;
        if (structuredSelection != null && !structuredSelection.isEmpty()) {
            for (Object treeElement : structuredSelection) {
                if (!(treeElement instanceof IPluginElement)) continue;
                createFilterRelatedAction |= ExtensionsFilterUtil.isFilterRelatedEnabled((IPluginElement)treeElement);
            }
        }
        return createFilterRelatedAction;
    }

    public static boolean isBoolean(String bool) {
        return bool.equalsIgnoreCase(BOOLEAN_TRUE) || bool.equalsIgnoreCase(BOOLEAN_FALSE);
    }
}

