/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.operations;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.jgit.lib.Repository;

public class IgnoreOperationUI {
    private final Collection<IPath> paths;

    public IgnoreOperationUI(Collection<IPath> paths) {
        this.paths = paths;
    }

    public void run() {
        final IgnoreOperation operation = new IgnoreOperation(this.paths);
        String jobname = UIText.IgnoreActionHandler_addToGitignore;
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    operation.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                if (operation.isGitignoreOutsideWSChanged()) {
                    IgnoreOperationUI.this.refresh();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(operation.getSchedulingRule());
        job.schedule();
    }

    private void refresh() {
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(this.paths);
        for (Repository repository : pathsByRepository.keySet()) {
            IndexDiffCache cache = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache();
            IndexDiffCacheEntry entry = cache.getIndexDiffCacheEntry(repository);
            if (entry == null) continue;
            entry.refresh();
        }
        GitLightweightDecorator.refresh();
    }
}

