/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.standalone.Options;

public class EclipseConnection {
    private String host;
    private String port;

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void reset() {
        this.host = null;
        this.port = null;
    }

    public boolean isValid() {
        return this.host != null && this.port != null;
    }

    public void connect(URL url) throws InterruptedException, Exception {
        try {
            HttpURLConnection connection = (HttpURLConnection)ProxyUtil.getConnection(url);
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
                secureConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        if (Options.isDebug()) {
                            System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                        }
                        return true;
                    }
                });
            }
            if (Options.isDebug()) {
                System.out.println("Connection  to control servlet created.");
            }
            connection.connect();
            if (Options.isDebug()) {
                System.out.println("Connection  to control servlet connected.");
            }
            int code = connection.getResponseCode();
            if (Options.isDebug()) {
                System.out.println("Response code from control servlet=" + code);
            }
            connection.disconnect();
            if (code == 302) {
                String redirectLocation = connection.getHeaderField("location");
                URL redirectURL = new URL(redirectLocation);
                if (url.equals(redirectURL)) {
                    if (Options.isDebug()) {
                        System.out.println("Redirecting to the same URL! " + redirectLocation);
                    }
                    return;
                }
                if (Options.isDebug()) {
                    System.out.println("Follows redirect to " + redirectLocation);
                }
                this.connect(redirectURL);
            }
            return;
        }
        catch (IOException ioe) {
            if (Options.isDebug()) {
                ioe.printStackTrace();
            }
            return;
        }
    }

    public void renew() throws Exception {
        Properties p = new Properties();
        Throwable throwable = null;
        Object var3_5 = null;
        try (FileInputStream is = new FileInputStream(Options.getConnectionFile());){
            p.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.host = (String)p.get("host");
        this.port = (String)p.get("port");
        if (Options.isDebug()) {
            System.out.println("Help server host=" + this.host);
        }
        if (Options.isDebug()) {
            System.out.println("Help server port=" + this.port);
        }
    }
}

