/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class AccessorClassModifier {
    private CompilationUnit fRoot;
    private AST fAst;
    private ASTRewrite fASTRewrite;
    private ListRewrite fListRewrite;
    private ICompilationUnit fCU;
    private List<FieldDeclaration> fFields;

    private AccessorClassModifier(ICompilationUnit cu) throws CoreException {
        this.fCU = cu;
        this.fRoot = SharedASTProvider.getAST((ITypeRoot)cu, SharedASTProvider.WAIT_YES, null);
        this.fAst = this.fRoot.getAST();
        this.fASTRewrite = ASTRewrite.create((AST)this.fAst);
        AbstractTypeDeclaration parent = null;
        if (this.fRoot.types().size() <= 0) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 10001, NLSMessages.AccessorClassModifier_missingType, null);
            throw new CoreException((IStatus)status);
        }
        parent = (AbstractTypeDeclaration)this.fRoot.types().get(0);
        this.fFields = new ArrayList<FieldDeclaration>();
        parent.accept((ASTVisitor)new GenericVisitor(){

            @Override
            public boolean visit(FieldDeclaration node) {
                int modifiers = node.getModifiers();
                if (!Modifier.isPublic((int)modifiers)) {
                    return false;
                }
                if (!Modifier.isStatic((int)modifiers)) {
                    return false;
                }
                List fragments = node.fragments();
                if (fragments.size() != 1) {
                    return false;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
                if (fragment.getInitializer() != null) {
                    return false;
                }
                AccessorClassModifier.this.fFields.add(node);
                return false;
            }
        });
        this.fListRewrite = this.fASTRewrite.getListRewrite((ASTNode)parent, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
    }

    private TextEdit getTextEdit() throws CoreException {
        Document document = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.fCU.getPath();
        if (manager != null && path != null) {
            manager.connect(path, LocationKind.NORMALIZE, null);
            try {
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                if (buffer != null) {
                    document = buffer.getDocument();
                }
            }
            finally {
                manager.disconnect(path, LocationKind.NORMALIZE, null);
            }
        }
        if (document == null) {
            document = new Document(this.fCU.getSource());
        }
        return this.fASTRewrite.rewriteAST((IDocument)document, this.fCU.getJavaProject().getOptions(true));
    }

    public static Change create(ICompilationUnit cu, NLSSubstitution[] substitutions) throws CoreException {
        NLSSubstitution substitution;
        HashMap<String, NLSSubstitution> newKeyToSubstMap = NLSPropertyFileModifier.getNewKeyToSubstitutionMap(substitutions);
        HashMap<String, NLSSubstitution> oldKeyToSubstMap = NLSPropertyFileModifier.getOldKeyToSubstitutionMap(substitutions);
        AccessorClassModifier sourceModification = new AccessorClassModifier(cu);
        String message = Messages.format(NLSMessages.NLSSourceModifier_change_description, BasicElementLabels.getFileName((ITypeRoot)cu));
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        int i = 0;
        while (i < substitutions.length) {
            substitution = substitutions[i];
            if (NLSPropertyFileModifier.doRemove(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                sourceModification.removeKey(substitution, (TextChange)change);
            }
            ++i;
        }
        i = 0;
        while (i < substitutions.length) {
            substitution = substitutions[i];
            if (substitution.isKeyRename() && NLSPropertyFileModifier.doReplace(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                sourceModification.renameKey(substitution, (TextChange)change);
            }
            ++i;
        }
        i = 0;
        while (i < substitutions.length) {
            substitution = substitutions[i];
            if (NLSPropertyFileModifier.doInsert(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                sourceModification.addKey(substitution, (TextChange)change);
            }
            ++i;
        }
        if (change.getChangeGroups().length == 0) {
            return null;
        }
        change.addEdit(sourceModification.getTextEdit());
        return change;
    }

    public static Change addFields(ICompilationUnit cu, List<String> fields) throws CoreException {
        AccessorClassModifier sourceModification = new AccessorClassModifier(cu);
        String message = Messages.format(NLSMessages.AccessorClassModifier_add_fields_to_accessor, BasicElementLabels.getFileName((ITypeRoot)cu));
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        int i = 0;
        while (i < fields.size()) {
            String field = fields.get(i);
            NLSSubstitution substitution = new NLSSubstitution(0, field, null, null, null);
            sourceModification.addKey(substitution, (TextChange)change);
            ++i;
        }
        if (change.getChangeGroups().length == 0) {
            return null;
        }
        change.addEdit(sourceModification.getTextEdit());
        return change;
    }

    public static Change removeFields(ICompilationUnit cu, List<String> fields) throws CoreException {
        AccessorClassModifier sourceModification = new AccessorClassModifier(cu);
        String message = Messages.format(NLSMessages.AccessorClassModifier_remove_fields_from_accessor, BasicElementLabels.getFileName((ITypeRoot)cu));
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        int i = 0;
        while (i < fields.size()) {
            String field = fields.get(i);
            NLSSubstitution substitution = new NLSSubstitution(0, field, null, null, null);
            sourceModification.removeKey(substitution, (TextChange)change);
            ++i;
        }
        if (change.getChangeGroups().length == 0) {
            return null;
        }
        change.addEdit(sourceModification.getTextEdit());
        return change;
    }

    private void removeKey(NLSSubstitution sub, TextChange change) {
        ASTNode node = this.findField((ASTNode)this.fRoot, sub.getInitialKey());
        if (node == null) {
            return;
        }
        String name = Messages.format(NLSMessages.AccessorClassModifier_remove_entry, BasicElementLabels.getJavaElementName(sub.getKey()));
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.remove(node, editGroup);
        change.addTextEditGroup(editGroup);
        this.fFields.remove(node);
    }

    private void renameKey(NLSSubstitution sub, TextChange change) {
        ASTNode node = this.findField((ASTNode)this.fRoot, sub.getInitialKey());
        if (node == null) {
            return;
        }
        String name = Messages.format(NLSMessages.AccessorClassModifier_replace_entry, BasicElementLabels.getJavaElementName(sub.getKey()));
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.remove(node, editGroup);
        this.fFields.remove(node);
        this.addKey(sub, editGroup);
        change.addTextEditGroup(editGroup);
    }

    private ASTNode findField(ASTNode astRoot, final String name) {
        class STOP_VISITING
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            STOP_VISITING() {
            }
        }
        final ASTNode[] result = new ASTNode[1];
        try {
            astRoot.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationFragment node) {
                    if (name.equals(node.getName().getFullyQualifiedName())) {
                        result[0] = node.getParent();
                        throw new STOP_VISITING();
                    }
                    return true;
                }
            });
        }
        catch (STOP_VISITING sTOP_VISITING) {}
        return result[0];
    }

    private void addKey(NLSSubstitution sub, TextChange change) {
        String name = Messages.format(NLSMessages.AccessorClassModifier_add_entry, BasicElementLabels.getJavaElementName(sub.getKey()));
        TextEditGroup editGroup = new TextEditGroup(name);
        change.addTextEditGroup(editGroup);
        this.addKey(sub, editGroup);
    }

    private void addKey(NLSSubstitution sub, TextEditGroup editGroup) {
        if (this.fListRewrite == null) {
            return;
        }
        String key = sub.getKey();
        FieldDeclaration fieldDeclaration = this.getNewFinalStringFieldDeclaration(key);
        if (this.fFields.size() == 0) {
            this.fListRewrite.insertLast((ASTNode)fieldDeclaration, editGroup);
            this.fFields.add(fieldDeclaration);
        } else {
            ArrayList<String> identifiers = new ArrayList<String>();
            for (FieldDeclaration field : this.fFields) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
                identifiers.add(fragment.getName().getIdentifier());
            }
            int insertionPosition = NLSUtil.getInsertionPosition(key, identifiers);
            if (insertionPosition < 0) {
                this.fListRewrite.insertBefore((ASTNode)fieldDeclaration, (ASTNode)this.fFields.get(0), editGroup);
                this.fFields.add(0, fieldDeclaration);
            } else {
                if (identifiers.size() == insertionPosition + 1) {
                    this.fListRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)this.fFields.get(insertionPosition), editGroup);
                } else {
                    int distAfter;
                    String beforeKey = identifiers.get(insertionPosition);
                    String afterKey = identifiers.get(insertionPosition + 1);
                    int distBefore = NLSUtil.invertDistance(key, beforeKey);
                    if (distBefore > (distAfter = NLSUtil.invertDistance(key, afterKey))) {
                        this.fListRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)this.fFields.get(insertionPosition), editGroup);
                    } else if (distBefore == distAfter && Collator.getInstance().compare(beforeKey, afterKey) < 0) {
                        this.fListRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)this.fFields.get(insertionPosition), editGroup);
                    } else {
                        this.fListRewrite.insertBefore((ASTNode)fieldDeclaration, (ASTNode)this.fFields.get(insertionPosition + 1), editGroup);
                    }
                }
                this.fFields.add(insertionPosition + 1, fieldDeclaration);
            }
        }
    }

    private FieldDeclaration getNewFinalStringFieldDeclaration(String name) {
        VariableDeclarationFragment variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.fAst.newSimpleName(name));
        FieldDeclaration fieldDeclaration = this.fAst.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName("String")));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        return fieldDeclaration;
    }
}

