/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class LevelTreeContentProvider
extends JavaSearchContentProvider
implements ITreeContentProvider {
    private Map<Object, Set<Object>> fChildrenMap;
    private StandardJavaElementContentProvider fContentProvider;
    public static final int LEVEL_TYPE = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_PACKAGE = 3;
    public static final int LEVEL_PROJECT = 4;
    private static final int[][] JAVA_ELEMENT_TYPES = new int[][]{{7}, {6, 5}, {4}, {2, 3}, {1}};
    private static final int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = JAVA_ELEMENT_TYPES.length - 1;
    private int fCurrentLevel;

    public LevelTreeContentProvider(JavaSearchResultPage page, int level) {
        super(page);
        this.fCurrentLevel = level;
        this.fContentProvider = new FastJavaElementProvider();
    }

    public Object getParent(Object child) {
        Object possibleParent = this.internalGetParent(child);
        if (possibleParent instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)possibleParent;
            int j = this.fCurrentLevel;
            while (j < MAX_LEVEL + 1) {
                int i = 0;
                while (i < JAVA_ELEMENT_TYPES[j].length) {
                    if (javaElement.getElementType() == JAVA_ELEMENT_TYPES[j][i]) {
                        return null;
                    }
                    ++i;
                }
                ++j;
            }
        } else if (possibleParent instanceof IResource) {
            IResource resource = (IResource)possibleParent;
            int j = this.fCurrentLevel;
            while (j < MAX_LEVEL + 1) {
                int i = 0;
                while (i < RESOURCE_TYPES[j].length) {
                    if (resource.getType() == RESOURCE_TYPES[j][i]) {
                        return null;
                    }
                    ++i;
                }
                ++j;
            }
        }
        if (this.fCurrentLevel != 2 && child instanceof IType) {
            IType type = (IType)child;
            if (possibleParent instanceof ICompilationUnit || possibleParent instanceof IClassFile) {
                possibleParent = type.getPackageFragment();
            }
        }
        return possibleParent;
    }

    private Object internalGetParent(Object child) {
        return this.fContentProvider.getParent(child);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    protected synchronized void initialize(AbstractTextSearchResult result) {
        super.initialize(result);
        this.fChildrenMap = new HashMap<Object, Set<Object>>();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                if (this.getPage().getDisplayedMatchCount(elements[i]) > 0) {
                    this.insert(null, null, elements[i]);
                }
                ++i;
            }
        }
    }

    protected void insert(Map<Object, Set<Object>> toAdd, Set<Object> toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.getSearchResult(), child) && toAdd != null) {
            this.insertInto(this.getSearchResult(), child, toAdd);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.fChildrenMap);
    }

    private boolean insertInto(Object parent, Object child, Map<Object, Set<Object>> map) {
        Set<Object> children = map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Set<Object> toRemove, Set<Object> toUpdate, Object element) {
        if (this.hasChildren(element)) {
            if (toUpdate != null) {
                toUpdate.add(element);
            }
        } else if (this.getPage().getDisplayedMatchCount(element) == 0) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeFromSiblings(element, parent)) {
                    this.remove(toRemove, toUpdate, parent);
                }
            } else if (this.removeFromSiblings(element, this.getSearchResult()) && toRemove != null) {
                toRemove.add(element);
            }
        } else if (toUpdate != null) {
            toUpdate.add(element);
        }
    }

    private boolean removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.fChildrenMap.get(parent);
        if (siblings != null) {
            return siblings.remove(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        int limit = this.getPage().getElementLimit();
        if (limit != -1 && limit < children.size()) {
            Object[] limitedArray = new Object[limit];
            Iterator<Object> iterator = children.iterator();
            int i = 0;
            while (i < limit) {
                limitedArray[i] = iterator.next();
                ++i;
            }
            return limitedArray;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        Set<Object> children = this.fChildrenMap.get(element);
        return children != null && !children.isEmpty();
    }

    @Override
    public synchronized void elementsChanged(Object[] updatedElements) {
        if (this.getSearchResult() == null) {
            return;
        }
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getPage().getViewer();
        HashSet<Object> toRemove = new HashSet<Object>();
        HashSet<Object> toUpdate = new HashSet<Object>();
        HashMap<Object, Set<Object>> toAdd = new HashMap<Object, Set<Object>>();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                this.insert(toAdd, toUpdate, updatedElements[i]);
            } else {
                this.remove(toRemove, toUpdate, updatedElements[i]);
            }
            ++i;
        }
        viewer.remove(toRemove.toArray());
        for (Object parent : toAdd.keySet()) {
            HashSet children = (HashSet)toAdd.get(parent);
            viewer.add(parent, children.toArray());
        }
        Iterator elementsToUpdate = toUpdate.iterator();
        while (elementsToUpdate.hasNext()) {
            viewer.refresh(elementsToUpdate.next());
        }
    }

    @Override
    public void clear() {
        this.initialize(this.getSearchResult());
        this.getPage().getViewer().refresh();
    }

    public void setLevel(int level) {
        this.fCurrentLevel = level;
        this.initialize(this.getSearchResult());
        this.getPage().getViewer().refresh();
    }

    static class FastJavaElementProvider
    extends StandardJavaElementContentProvider {
        FastJavaElementProvider() {
        }

        @Override
        public Object getParent(Object element) {
            Object parent = this.internalGetParent(element);
            if (parent == null && element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                Object javaElement = adaptable.getAdapter(IJavaElement.class);
                if (javaElement != null) {
                    parent = this.internalGetParent(javaElement);
                } else {
                    Object resource = adaptable.getAdapter(IResource.class);
                    if (resource != null) {
                        parent = this.internalGetParent(resource);
                    }
                }
            }
            return parent;
        }
    }
}

