/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.toc.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.text.DocumentObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ua.core.toc.ITocConstants;
import org.eclipse.pde.internal.ua.core.toc.text.Toc;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;

public abstract class TocObject
extends DocumentObject
implements ITocConstants,
Serializable {
    private static final long serialVersionUID = 1L;

    public TocObject(TocModel model, String tagName) {
        super((IModel)model, tagName);
    }

    protected String getAttributeIndent() {
        return " ";
    }

    public List<TocObject> getChildren() {
        ArrayList<TocObject> list = new ArrayList<TocObject>();
        IDocumentElementNode[] childNodes = this.getChildNodes();
        if (childNodes.length > 0) {
            IDocumentElementNode[] iDocumentElementNodeArray = childNodes;
            int n = childNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
                if (childNode instanceof TocObject) {
                    list.add((TocObject)childNode);
                }
                ++n2;
            }
        }
        return list;
    }

    public boolean isLeafNode() {
        return !this.canBeParent();
    }

    public abstract boolean canBeParent();

    public TocModel getModel() {
        IModel sharedModel = this.getSharedModel();
        if (sharedModel instanceof TocModel) {
            return (TocModel)sharedModel;
        }
        return null;
    }

    public Toc getToc() {
        TocModel model = this.getModel();
        if (model != null) {
            return model.getToc();
        }
        return null;
    }

    public abstract String getName();

    public abstract String getPath();

    public TocObject getParent() {
        IDocumentElementNode parent = this.getParentNode();
        return parent instanceof TocObject ? (TocObject)parent : null;
    }

    public boolean descendsFrom(TocObject obj) {
        if (this.equals(obj)) {
            return true;
        }
        if (this.getParent() != null && obj.canBeParent()) {
            return this.getParent().descendsFrom(obj);
        }
        return false;
    }

    public abstract int getType();

    public TocObject getPreviousSibling(TocObject tocObject) {
        return (TocObject)this.getPreviousSibling((IDocumentElementNode)tocObject, TocObject.class);
    }

    public TocObject getNextSibling(TocObject tocObject) {
        return (TocObject)this.getNextSibling((IDocumentElementNode)tocObject, TocObject.class);
    }

    public boolean canBeRemoved() {
        if (this.getType() == 0) {
            return false;
        }
        TocObject parent = this.getParent();
        if (parent != null) {
            if (parent.getType() == 0) {
                return parent.getChildren().size() > 1;
            }
            return true;
        }
        return false;
    }
}

