/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;
import org.apache.tools.ant.util.FileUtils;

public class ScpFromMessageBySftp
extends ScpFromMessage {
    private static final int HUNDRED_KILOBYTES = 102400;
    private String remoteFile;
    private final File localFile;
    private boolean isRecursive = false;
    private boolean verbose = false;

    public ScpFromMessageBySftp(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        this(verbose, session, aRemoteFile, aLocalFile, recursive, false);
    }

    public ScpFromMessageBySftp(Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        this(false, session, aRemoteFile, aLocalFile, recursive);
    }

    public ScpFromMessageBySftp(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive, boolean preserveLastModified) {
        super(verbose, session, aRemoteFile, aLocalFile, recursive, preserveLastModified);
        this.verbose = verbose;
        this.remoteFile = aRemoteFile;
        this.localFile = aLocalFile;
        this.isRecursive = recursive;
    }

    @Override
    public void execute() throws IOException, JSchException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.connect();
            try {
                SftpATTRS attrs = channel.stat(this.remoteFile);
                if (attrs.isDir() && !this.remoteFile.endsWith("/")) {
                    this.remoteFile = this.remoteFile + "/";
                }
            }
            catch (SftpException attrs) {
                // empty catch block
            }
            this.getDir(channel, this.remoteFile, this.localFile);
        }
        catch (SftpException e) {
            JSchException schException = new JSchException("Could not get '" + this.remoteFile + "' to '" + this.localFile + "' - " + e.toString());
            schException.initCause((Throwable)e);
            throw schException;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        this.log("done\n");
    }

    private void getDir(ChannelSftp channel, String remoteFile, File localFile) throws IOException, SftpException {
        String pwd = remoteFile;
        if (remoteFile.lastIndexOf(47) != -1 && remoteFile.length() > 1) {
            pwd = remoteFile.substring(0, remoteFile.lastIndexOf(47));
        }
        channel.cd(pwd);
        if (!localFile.exists()) {
            localFile.mkdirs();
        }
        Vector files = channel.ls(remoteFile);
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            ChannelSftp.LsEntry le = (ChannelSftp.LsEntry)files.elementAt(i);
            String name = le.getFilename();
            if (le.getAttrs().isDir()) {
                if (name.equals(".") || name.equals("..")) continue;
                this.getDir(channel, channel.pwd() + "/" + name + "/", new File(localFile, le.getFilename()));
                continue;
            }
            this.getFile(channel, le, localFile);
        }
        channel.cd("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFile(ChannelSftp channel, ChannelSftp.LsEntry le, File localFile) throws IOException, SftpException {
        boolean trackProgress;
        String path;
        int i;
        String remoteFile = le.getFilename();
        if (!localFile.exists() && (i = (path = localFile.getAbsolutePath()).lastIndexOf(File.pathSeparator)) != -1 && path.length() > File.pathSeparator.length()) {
            new File(path.substring(0, i)).mkdirs();
        }
        if (localFile.isDirectory()) {
            localFile = new File(localFile, remoteFile);
        }
        long startTime = System.currentTimeMillis();
        long totalLength = le.getAttrs().getSize();
        SftpProgressMonitor monitor = null;
        boolean bl = trackProgress = this.getVerbose() && totalLength > 102400L;
        if (trackProgress) {
            monitor = this.getProgressMonitor();
        }
        try {
            this.log("Receiving: " + remoteFile + " : " + le.getAttrs().getSize());
            channel.get(remoteFile, localFile.getAbsolutePath(), monitor);
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.logStats(startTime, endTime, (int)totalLength);
        }
        if (this.getPreserveLastModified()) {
            FileUtils.getFileUtils().setFileLastModified(localFile, (long)le.getAttrs().getMTime() * 1000L);
        }
    }
}

